import java.util.List;

public class Form {
    private String name;
    private int age;
    private List<String> topAnime;

    public Form (String name,int age,List<String> topAnime){
        this.name=name;
        this.age=age;
        this.topAnime=topAnime;
    }

    public void setName(String name) throws NullInputException{
        if (name==null){
            throw new NullInputException("Wrong name");
        }
        this.name = name;
    }

    public void setAge(int age) throws WrongAgeException{
        if (age<1 || age>110){
            throw new WrongAgeException("Your age must be positive");
        }
        this.age = age;
    }

    public void setTopAnime(List<String> topAnime) throws NullInputException {
        if (topAnime==null) {
            throw new NullInputException("Your top list of Anime is empty");
        }
        this.topAnime = topAnime;
    }

    public String getName() {
        return name;
    }

    public int getAge() {
        return age;
    }

    public List<String> getTopAnime() {
        return topAnime;
    }
}
