package tictactoe.gui;

import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import tictactoe.BoardGame;
import tictactoe.InvalidMoveException;

/**
 * This class picks up mouse clicks and propogates them
 * to a tictactoe.Player of the tictactoe.BoardGame.
 *
 */
public class PlaceListener implements EventHandler<MouseEvent> {
	private final Place place;
	private final GameGUI gui;
	
	public PlaceListener(Place myPlace, GameGUI myGui) {
		place = myPlace;
		gui = myGui;
	}

	/**
	 * When the mouse is clicked, we ask the current player to
	 * make the corresponding move.  Report when the game is over.
	 */
	@Override
	public void handle(MouseEvent event) {
		BoardGame game = gui.getGame();
		int col = place.getCol();
		int row = place.getRow();
		if (game.notOver()) {
			try {
				((GUIplayer) game.currentPlayer()).move(col,row);
				gui.showFeedBack(game.currentPlayer().mark() + " plays");
			} catch (AssertionError err) {
				gui.showFeedBack(err.getMessage());
			} catch (InvalidMoveException err) {
				gui.showFeedBack(err.getMessage());
			}
			if (!game.notOver()) {
				gui.showFeedBack("Game over -- " + game.winner() + " wins!");
			}
		} else {
			gui.showFeedBack("The game is over!");
		}		
	}
}

