package tictactoe;

/**
 * Minimal interface for tictactoe.Player classes that get moves from user
 * and forward them to the game.
 */
public interface Player {
	/**
	 * @return the char representation of this tictactoe.Player
	 * @see AbstractBoardGame#toString
	 */
	public char mark();
	/**
	 * @return whether this tictactoe.Player represents "nobody".
	 * (By convention, a tictactoe.Player with a blank as its mark.)
	 */
	public boolean isNobody();
	/**
	 * Let this player join a particular game.
	 * Set by a tictactoe.BoardGame when it is instantiated with Players.
	 */
	public void setGame(BoardGame game);
}

