package tictactoe;

/**
 * Manage interaction with user.
 * This class implements "nobody" -- a tictactoe.Player that has an identity,
 * but does not make moves.  Serves as a superclass for other implementations.
 */
public class InactivePlayer implements Player {
	private final char mark;
	protected BoardGame game;

	/**
	 * The normal contructor to use.
	 * @param initMark the character representing this player ('X' or 'O')
	 */
	public InactivePlayer(char initMark) {
		mark = initMark;
	}
	
	/**
	 * Special constructor for the tictactoe.Player representing nobody.
	 * (Used by tictactoe.TicTacToe as a placeholder when there is no
	 * winner yet.)
	 * @see AbstractBoardGame
	 */
	public InactivePlayer() {
		this(' ');
	}

	/**
	 * @return the char representation of this tictactoe.Player
	 * @see AbstractBoardGame#toString
	 */
	public char mark() { return mark; }
	
	/**
	 * @return the String representation of this tictactoe.Player
	 * @see GameDriver#playGame
	 */
	public String toString() {
		if (this.isNobody())
			return "nobody";
		else
			return new Character(this.mark()).toString();
	}
	
	/**
	 * @return whether this tictactoe.Player represents "nobody".
	 * (By convention, a tictactoe.Player with a blank as its mark.)
	 */
	public boolean isNobody() {
		return this.mark() == ' ';
	}

	/**
	 * Let this player join a particular game.
	 * Set by a tictactoe.BoardGame when it is instantiated with Players.
	 */
	public void setGame(BoardGame aGame) {
		game = aGame;
	}
}
