package library;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.util.HashSet;

import static org.junit.jupiter.api.Assertions.*;

public class LibraryTest {
    private Library library, emptyLibrary;
    private Item book1, book2, game1, game2, book3;

    @BeforeEach
    public void setUp() {
        emptyLibrary = new Library();
        library = new Library();
        book1 = new Book("Horizon", 2020);
        book2 = new Book("Distant Sky", 2019);
        game1 = new IOSGame("XCOM2", 2020);
        game2 = new PCGame("Starcraft2", 2010);
        book3 = new Book("Starcraft2", 2011);
        library.add(book1).add(book2).add(book3).add(game1).add(game2);
    }

    @Test
    public void testIsEmpty() {
        assertTrue(emptyLibrary.isEmpty());
        assertFalse(library.isEmpty());
    }

    @Test
    public void testSearchByName() {
        HashSet<Item> expected = new HashSet<>();
        expected.add(book1);
        assertEquals(expected, library.search(new NamePredicate("Horizon")));
    }

    @Test
    public void testSearchByYear() {
        HashSet<Item> expected = new HashSet<>();
        expected.add(book1);
        expected.add(game1);
        assertEquals(expected, library.search(new YearPredicate(2020)));
    }

    @Test
    public void testOrPredicate() {
        OrPredicate or = new OrPredicate(new NamePredicate("Horizon"),
                                         new YearPredicate(2020));
        HashSet<Item> expected = new HashSet<>();
        expected.add(book1);
        expected.add(game1);
        assertEquals(expected, library.search(or));
    }

    @Test
    public void testAndPredicate() {
        AndPredicate and = new AndPredicate(new NamePredicate("Horizon"),
                                            new YearPredicate(2020));
        HashSet<Item> expected = new HashSet<>();
        expected.add(book1);
        assertEquals(expected, library.search(and));
    }

    @Test
    public void testAndOrPredicate() {
        AndPredicate and = new AndPredicate(new PrefixPredicate("Star"),
                new YearPredicate(2010));

        OrPredicate or = new OrPredicate(new NamePredicate("Horizon"),
                and);

        HashSet<Item> expected = new HashSet<>();
        expected.add(book1);
        expected.add(game2);
        assertEquals(expected, library.search(or));
    }

    @Test
    public void testSearchByPrefix() {
        HashSet<Item> expected = new HashSet<>();
        expected.add(game2);
        expected.add(book3);
        assertEquals(expected, library.search(new PrefixPredicate("Star")));
    }

    @Test
    public void testSearchByName02() {
        HashSet<Item>  result = library.search(new NamePredicate("Starcraft2"));
        HashSet<Item> expected = new HashSet<>();
        expected.add(game2);
        expected.add(book3);
        assertEquals(expected, result);
    }
}
