package library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Library {
    private final List<Item> items;

    public Library() {
        items = new ArrayList<>();
    }

    public boolean isEmpty() {
        return items.isEmpty();
    }

    public Library add(Item anItem) {
        items.add(anItem);
        return this;
    }

    public HashSet<Item> search(Predicate p) {
        HashSet<Item> result = new HashSet<>();
        for(Item item : items) {
            if (p.check(item)) {
                result.add(item);
            }
        }

        return result;
    }
}
