package library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Library {
    private final List<Item> items;

    public Library() {
        items = new ArrayList<>();
    }

    public boolean isEmpty() {
        return items.isEmpty();
    }

    public Library add(Item anItem) {
        items.add(anItem);
        return this;
    }

    public HashSet<Item> search(String aName) {
        HashSet<Item> result = new HashSet<>();
        for(Item item : items) {
            if (item.getName().equals(aName)) {
                result.add(item);
            }
        }

        return result;
    }

    public HashSet<Item> searchByYear(int aYear) {
        HashSet<Item> result = new HashSet<>();
        for(Item item : items) {
            if (item.getYear() == aYear) {
                result.add(item);
            }
        }

        return result;
    }

    public HashSet<Item> searchByPrefix(String aPrefix) {
        HashSet<Item> result = new HashSet<>();
        for(Item item : items) {
            if (item.getName().startsWith(aPrefix)) {
                result.add(item);
            }
        }
        return result;
    }
}
