# -*- coding: utf-8 -*-
"""Pauta_Auxiliar_13.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1Z7C_DaAxIclzL6TFh1WiSPxvM8X4XM-H

# Auxiliar 13 - Clases y Objetos

## Pregunta 1

En esta pregunta, usted deberá implementar la estructura recursiva lista (de la Clase 9) con clases de python. Esta debe poder agregar elementos a la lista, poder obtener la cabeza de la lista, obtener la cola de la lista y saber si la lista es vacia. Para lo anterior mencionado, cree métodos que logren hacer lo pedido.

HINT: Incorpore un campo llamado *vacia*, que indique cuando la lista sea una lista vacia. Además, en vez de usar None para representar una lista vacia, utilice una Lista que tenga el campo *vacia* en True.
"""

# Campos:
# valor: any
# siguiente: Lista or None
# vacia: bool
class Lista:

  # Constructor
  def __init__(self, valor, siguiente, vacia=False):
    self.valor = valor
    self.siguiente = siguiente
    self.vacia = vacia
  
  # cabeza: None -> any
  # Entrega la cabeza de la lista
  def cabeza(self):
    return self.valor
  
  # cola: None -> Lista or None
  # Entrega la cola de la lista
  def cola(self):
    return self.siguiente
  
  # vacia: None -> Bool
  # Entrega True si la lista está vacia, False de lo contrario
  def es_vacia(self):
    return self.vacia
  
  # agregarElemento: any -> None
  # Agrega un elemento al comienzo de la lista
  def agregarElemento(self, elemento):
    self.siguiente = Lista(self.valor, self.siguiente)
    self.valor = elemento

lista_test = Lista(5, Lista(None, None, True))

assert lista_test.cabeza() == 5
assert lista_test.es_vacia() == False
assert lista_test.cola().es_vacia() == True

lista_test.agregarElemento(8)

assert lista_test.cabeza() == 8
assert lista_test.cola().cabeza() == 5
assert lista_test.cola().cola().es_vacia() == True

"""## Pregunta 2

A usted le gustan mucho las mascotas, y es por eso que se le ocurrió que sería buena idea poder tener mascotas dentro de un programa. Debido a lo anterior, usted debe crear la clase *Mascota que posea los siguientes campos y métodos:

**Campos**:
- nombre: representa el nombre de la mascota
- tipo: representa que tipo de mascota es, por ejemplo: perro, gato, hamster, etc.
- energía: un número que representa la cantidad de energía de la mascota. Con ella la mascota es capaz de jugar y realizar actividades.

**Métodos**:
- alimentar: alimenta a la mascota, teniendo como efecto que aumente su energía en 50.
- jugar: la mascota juega, siempre y cuando tenga energía suficiente disponible para hacerlo. Asuma que jugar gasta 20 de energía.

Además de los métodos anteriores, deberá implementar los métodos accesores (get) y mutadores (set) para todos los campos de la clase. Para los métodos alimentar y jugar, utilice los mutadores y accesores.
"""

# Campos:
# nombre: str
# tipo: str
# energia: int
class Mascota:

  # Constructor
  def __init__(self, nombre, tipo, energia):
    self.nombre = nombre
    self.tipo = tipo
    self.energia = energia
  
  ######### Métodos accesores ############

  # getNombre: None -> str
  # Entrega el nombre de la mascota
  def getNombre(self):
    return self.nombre
  
  # getTipo: None -> str
  # Entrega el tipo de la Mascota
  def getTipo(self):
    return self.tipo

  # getEnergia: None -> int
  # Entrega la energia actual de la Mascota
  def getEnergia(self):
    return self.energia
  
  ######### Métodos mutadores ############

  # setNombre: str -> None
  # Modifica el nombre de la mascota
  def setNombre(self, nombre):
    self.nombre =  nombre
  
  # setTipo: str -> None
  # Modifica el tipo de la mascota
  def setTipo(self, tipo):
    self.tipo = tipo
  
  # setEnergia: int -> None
  # Modifica la energia de la mascota
  def setEnergia(self, energia):
    self.energia =  energia
  
  ######### Otros métodos ############

  # alimentar: None -> None
  # Alimenta a la mascota, aumenta su nivel de energía en 50
  def alimentar(self):
    self.setEnergia(self.getEnergia() + 50)
  
  # jugar: None -> None
  # Juega con la mascota, lo cual requiere de 20 de energía.
  def jugar(self):
    energia_actual = self.getEnergia()
    if energia_actual >= 20:
      self.setEnergia(energia_actual - 20)
    else:
      print("Energía no es suficiente para jugar")

# Tests

mascota = Mascota("Cachupin", "perro", 20)

assert mascota.getNombre() == "Cachupin"
assert mascota.getTipo() == "perro"
assert mascota.getEnergia() == 20

mascota.jugar()

assert mascota.getEnergia() == 0

mascota.jugar()

assert mascota.getEnergia() == 0

mascota.alimentar()
mascota.alimentar()
mascota.alimentar()

assert mascota.getEnergia() == 150

mascota.setNombre("michi")
mascota.setTipo("gato")

assert mascota.getNombre() == "michi"
assert mascota.getTipo() == "gato"

"""## Pregunta 3

En la Clase 20 se usa como ejemplo la Clase *Automovil*, la cual no está implementada. Es por esto que en esta pregunta deberá implementar la Clase *Automovil* con su respectivo constructor y los siguientes campos y métodos.

**Campos:**
- *color:* indica el color del automovil.
- *nivel de gasolina*: indica el nivel actual de gasolina.
- *velocidad actual*: indica la velocidad actual del automovil.
- *velocidad máxima*: indica la velocidad máxima del automovil.
- *apagado*: indica si el automovil está encendido o apagado.
- *gasolina maxima*: indica la maxima cantidad de gasolina del automovil.

**Métodos:**
- *cambiarColor*: cambia el color del automovil.
- *encender*: enciende el automovil (solo si está apagado).
- *apagar*: apaga el automovil (solo si está encendido).
- *acelerar*: aumenta la velocidad del automovil en 10 (la velocidad actual no puede superar la velocidad máxima). Además gasta 1 de gasolina.
- *frenar*: disminuye en 10 la velocidad del automovil (la velocidad no puede ser menor a 0).
- *gasolinaActual*: entrega la cantidad de gasolina actual.
- *llenarEstanque*: llena el nivel de gasolina a su maximo.

Asuma que al crear un vehiculo este empezará sin gasolina, apagado y no en movimiento. Además asuma que si el automovil ya llego a su velocidad maxima, de todas formas gastará gasolina al acelerar.
"""

# Campos:
# color: str
# nivelGasolina: int
# velocidadActual: int
# velocidadMaxima: int
# apagado: bool
# gasolinaMaxima: int
class Automovil:

  # Constructor
  def __init__(self, color, velocidadMaxima, gasolinaMaxima):
    # Inicialización de campos
    self.color = color
    self.nivelGasolina = 0
    self.velocidadActual = 0
    self.velocidadMaxima =  velocidadMaxima
    self.apagado = True
    self.gasolinaMaxima = gasolinaMaxima
  
  # cambiarColor: str -> None
  # Cambia el color del automovil
  def cambiarColor(self, color):
    self.color = color
  
  # encender: None -> None
  # Enciende el automovil solo si está apagado
  def encender(self):
    if self.apagado:
      self.apagado = False
    else:
      print("Automovil ya encendido")
  
  # apagar: None -> None
  # Apaga el automovil solo si está encendido
  def apagar(self):
    if not self.apagado:
      self.apagado = True
    else:
      print("Automovil ya apagado")
  
  # acelerar: None -> None
  # Acelera el automovil, aumentando su velocidad en 10, y disminuyendo su gasolina en 1.
  # Solo acelera si tiene gasolina. Además no aumenta la velocidad actual si el automovil ya alcanzó la velocidad maxima
  def acelerar(self):
    if self.gasolinaActual() > 0 and self.apagado==False:
      if self.velocidadActual + 10 >= self.velocidadMaxima:
        self.velocidadActual = self.velocidadMaxima
      else:
        self.velocidadActual += 10
      self.nivelGasolina -=1
    else:
      print("No hay gasolina o su automovil esta apagado")
  
  # frenar: None -> None
  # Frena el automovil dejando su velocidad en 0
  def frenar(self):
    self.velocidadActual -= 10
    if self.velocidadActual < 0:
      self.velocidadActual = 0

  # gasolinaActual: None -> int
  # Entrega el nivel actual de gasolina
  def gasolinaActual(self):
    return self.nivelGasolina
  
  # llenarEstanque: None -> None
  # Llena el nivel de gasolina con el maximo posible
  def llenarEstanque(self):
    self.nivelGasolina =  self.gasolinaMaxima

# Tests

automovil = Automovil("azul", 20, 5)

assert automovil.color == "azul"
assert automovil.apagado == True
assert automovil.velocidadMaxima == 20
assert automovil.velocidadActual == 0
assert automovil.gasolinaMaxima == 5
assert automovil.nivelGasolina == 0

automovil.cambiarColor("verde")
assert automovil.color == "verde"

automovil.llenarEstanque()
assert automovil.nivelGasolina == 5

automovil.encender()
assert automovil.apagado == False

automovil.acelerar()
assert automovil.velocidadActual == 10
assert automovil.nivelGasolina == 4

automovil.acelerar()
assert automovil.velocidadActual == 20
assert automovil.nivelGasolina == 3

automovil.acelerar()
assert automovil.velocidadActual == 20
assert automovil.nivelGasolina == 2

automovil.frenar()
assert automovil.velocidadActual == 10

automovil.frenar()
assert automovil.velocidadActual == 0

automovil.frenar()
assert automovil.velocidadActual == 0