# -*- coding: utf-8 -*-
"""Pauta Auxiliar 11.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1Tl3OiGy5WU7t9yeBoNExeNnHF6sHzPoJ

# Pauta Auxiliar 11

### Estructuras Indexadas, String

Auxiliares: Nadia Decar, Nelson Marambio, Albani Olvieri, Monserrat Prado, Lucas Torrealba, Ricardo Valdivia

### Pregunta 1. Sopa de letras

Esta pregunta onsiste en modelar una sopa de letras como una lista de strings, como la siguiente:

```python
L = ['a', 'b', 'r', 'a', 'c', 'a', 'd', 'a', 'b', 'r', 'a']
```

Es para esto que se le pide crear las siguientes funciones, que operan con listas de letras:

a)  Escriba la función contarLetras(L, letra) que cuenta la cantidad de veces que se repite la 'letra' entregada dentro de la lista L. En el ejemplo, contarLetras(L, 'a') entregaría 5

b) Escriba la función invertir(L) que toma una lista de letras como la del ejemplo, y entrega una **nueva lista**, con los elementos invertidos de esa lista. Ejemplo:
```python
invertir(L) entrega ['a', 'r', 'b', 'a', 'd', 'a', 'c', 'a', 'r', 'b', 'a']
```

c) Escriba una función mezclarSopas(L1,L2), que toma dos listras de letras de distintos tamaños, y retorna una lista con los string concatenados uo por uno. En el caso que una lista sea más corta que la cotra, debe concatenarse con un guión bajo. Ejemplo:
```python
L1 = ['a', 'b', 'r', 'a']
L2 = ['c', 'a']
mezclarSopas(L1,L2) entrega ['ac', 'ba', 'r_', 'a_']
```

d) Escriba una funci´on sinRepeticiones(L) que recibe una lista de letras, y
retorna una lista, sin letras repetidas.

```python
sinRepeticiones(L) entrega ['a', 'b', 'r', 'c', 'd']
```
"""

# listas para usar en los ejemplos y test
Lejemplo = ['a', 'b', 'r', 'a', 'c', 'a', 'd', 'a', 'b', 'r', 'a']
Lcorta1 = ['a', 'b', 'r', 'a']
Lcorta2 = ['c','a']
Lcorta3 = ['c', 'a', 'r', 'z']

# a)
# contarLetras: list(str) str -> int
# cuenta la cantidad de una letra en una lista de letras
# Ej: contarLetras(Lejemplo,'a') entrega 5
def contarLetras(L,letra):
  assert type(L) == list
  assert type(letra) == str
  contador = 0
  # En este caso, usaremos un for, que recorre 'automaticamente' cada
  # elemento e de la lista L en cada ciclo.
  for e in L:
    if e == letra:
      contador = contador + 1
    # Si no son iguales, no aumentamos el contador, asi que ignoramos
    # ese caso, no hay else
  return contador
# Test
assert contarLetras(Lejemplo,'a') == 5
assert contarLetras(Lejemplo,'z') == 0
assert contarLetras([],'a') == 0
'''
En algunos casos, podemos usar las funciones nativas de python, para operar
con listas o strings. Si es aplicable, puede facilitar mucho la resolución
de los problemas.
'''
# contarLetras: list(str) str -> int
# cuenta la cantidad de una letra en una lista de letras
# Ej: contarLetras(Lejemplo,'a') entrega 5
def contarLetras2(L,letra):
  assert type(L) == list
  assert type(letra) == str
  return L.count(letra)

assert contarLetras2(Lejemplo,'a') == 5
assert contarLetras2(Lejemplo,'z') == 0
assert contarLetras2([],'a') == 0

# b)
# invertir: list(str) -> list(str)
# crea una nueva lista, con los elementos en orden inverso de la lista entregada
# Ej: invertir(Lcorta1) entrega ['a', 'r', 'b', 'a']
def invertir(L):
  assert type(L) == list
  # En este caso, no podemos usar el metodo list.reverse() de python
  # ya que estariamos editando la lista original, y no es la idea del problema
  # que nos pide una nueva lista invertida.
  nuevaL = []
  i = len(L) - 1 # Los elementos se cuentan desde 0 hasta Total-1
  while i >= 0:
  # Tomamos el elemento, y lo agregamos a la otra lista,
  # usando lista.append(elemento), que lo agrega al final de la lista.
    letra = L[i]
    nuevaL.append(letra)
  # para que en algun momento se termine el while debemos ir modificando la 
  # variable que se verifica como condicion.
    i= i-1
  return nuevaL
assert invertir(Lejemplo) == ['a', 'r', 'b', 'a', 'd', 'a', 'c', 'a', 'r', 'b', 'a']
assert invertir(Lcorta1) == ['a', 'r', 'b', 'a']
assert invertir([]) == []

# c)
# mezclarSopas: list(str) list(str) -> list(str)
# toma dos listas de letras, y mezcla sus elementos uno a uno
# Ej: mezclarSopas(Lcorta1, Lcorta3) entrega ['ac', 'ba', 'r_', 'a_']
def mezclarSopas(L1,L2):
  assert type(L1) == list and type(L2) == list
  # Obtenemos el largo de ambas listas
  largo1 = len(L1)
  largo2 = len(L2)
  i = 0
  nuevaL = []
  while i < min(largo1,largo2):
  # Se juntan las letras, y se agregan a la nueva lista.
    e = L1[i] + L2[i]
    nuevaL.append(e)
    i = i + 1
  # Notar que la variable i indica en que punto quedamos de la lista mas larga, lo que
  # nos permite continuar leyendo elementos a partir de ese punto.
  if largo1 > largo2:
    while i < largo1:
      e = L1[i] + '_'
      nuevaL.append(e)
      i = i + 1
  elif largo1 < largo2:
    while i < largo2:
      e = '_' + L2[i]
      nuevaL.append(e)
      i = i + 1
  return nuevaL
# test
assert mezclarSopas(Lcorta1, Lcorta2) == ['ac', 'ba', 'r_', 'a_']
assert mezclarSopas(Lcorta1, Lcorta3) == ['ac', 'ba', 'rr', 'az']
assert mezclarSopas([],Lcorta2) == ['_c','_a']

# d)
# sinRepeticiones: list(str) -> list(str)
# toma una lista de letras, y genera una nueva lista con solo 1 aparicion
# de las letras de la lista original
# ej: sinRepeticiones(Lprueba) entrega ['a', 'b', 'r', 'c', 'd']
def sinRepeticiones(L):
  assert type(L) == list
  # Creamos una lista vacia, y le vamos agregando letras, siempre y cuando
  # no existan en esa lista previamente 
  nuevaL = []
  for e in L:
    if contarLetras(nuevaL,e) == 0:
      nuevaL.append(e)
  return nuevaL
# Test
assert sinRepeticiones(Lejemplo) == ['a', 'b', 'r', 'c', 'd']
assert sinRepeticiones([]) == []

"""### Pregunta 2. A rotar!

Escriba la función de encabezamiento def rotacionParcial(L) que modifique y la lista L de N elementos de modo que
L[0] queda fijo, L[1] pasa a L[2], L[2] a L[3], ..., L[N-2] a L[N-1] y finalmente L[N-1] pasa a L[1]. Por ejemplo, si
L=['A','B','C','D','E','F'], entonces rotacionParcial(L) debe dejar L= ['A','F,'B','C','D','E'].

**Como Restriccion especifica, esta pregunta solo se puede realizar ocupando While(recursion y for no estan permitidos)** 
"""

# rotacionParcial: lista -> lista
# realiza una rotacion desde el indice 1 hasta el N-1
# Ejemplo de uso rotacionParcial(['A', 'B', 'C', 'D', 'E', 'F'])
# nos entrega ['A', 'F', 'B', 'C', 'D', 'E']
def rotacionParcial(L):
  n=len(L)-1 
  ultimo=L[n] 
  while n>1:
    L[n]=L[n-1] 
    n-=1
  L[1]=ultimo
  return L

L=['A', 'B', 'C', 'D', 'E', 'F']
assert rotacionParcial(L) == ['A', 'F', 'B', 'C', 'D', 'E']

"""### Pregunta 3. A medir!

Se le pide registrar las mediciones de residuos tóxicos de un lago en una lista de listas (Matriz), en donde cada lista representa las mediciones en un sector especifico del lago, se sabe que el mayor valor de concentración es de 100, y que "F" representa una medición fallida.

```python
[ [20.1, 30.5, 25.4, 24, 23, 'F'],
[ 'F', 'F', 18.3, 25.2, 30.1, 30],
... ,
[11.1, 22, 24, 26.6, 28.8, 30] ]

```

Se desea obtener las concetracione spromedio de cada zona de un registro como el anterior,  y entregarlas en una lista. Para esto, cree la funcion promedioConcentracion(M), que recive una matriz como la antes descrita, y le retorna una lista, en donde cada elemento representa la concentración de toxico promedio en cada sector. Para los casos con mediciones fallidas (letra "F"), entonces se calcula el promedio de ese día con menos datos. En caso de que todos los registros en un sector sean fallidos, entonces el promedio será "F".


Además se le pide programar las funciones, minConcentracion(M) y maxConcentracion(M), de manera análoga a la anterior, pero que entrega los mínimos y máximos por zona respectivamente.



"""

# matrices (listas de listas) de ejemplo para los test
matrizTox =[[20.1, 30.5, 25.4, 24, 23, 'F'],
['F', 'F', 18.3, 25.2, 30.1, 30] ,
[30, 29, 23, 'F', 'F', 11.1],
[11.1, 22, 24, 26.6, 28.8, 30] ]
# una matriz que tiene una fila solo con 'E'
matrizE =[[20.1, 30.5, 25.4, 24, 23, 'F'],
['F','F','F','F','F','F'],
['F', 'F', 18, 25.3, 30.1, 30] ]



# parte 1
# promedioConcentracion: list(list(num|str)) -> list(num|str)
# revisa una matriz de mediciones, y calcula los promedios por cada fila
# Ej: promedioConcentracion(MatrizTox) entrega [24.6, 25.9, 23.275, 23.75]
def promedioConcentracion(M):
  assert type(M) == list
  # creamos una lista vacia, donde iremos agregando el promedio de cada zona
  listaC = []
  # para cada zona
  for zona in M:
    totalcorrecto = 0
    sumaC = 0
  # para cada medición en una zona en particular
    for med in zona:
    # si la medicion no es incorrecta, la acumulamos en las variables.
      if med != 'F':
        totalcorrecto = totalcorrecto + 1
        sumaC = sumaC + med
  # Finalmente para esa zona, dependiendo si hay al menos una medición
  # correcta o no, calculamos el promedio o colocamos una 'E'
    if totalcorrecto != 0:
      listaC.append(1.0*sumaC/totalcorrecto)
    else:
      listaC.append('F')
  return listaC
# Test
assert promedioConcentracion(matrizTox) == [24.6, 25.9, 23.275, 23.75]
assert promedioConcentracion(matrizE) == [24.6, 'F', 25.85]

# parte 2
# minConcentracion: list(list(num|str)) -> list(num|str)
# revisa una matriz de mediciones, y calcula el valor minimo en cada fila
# Ej: minConcentracion(MatrizTox) entrega [20.1, 18.3, 11.1, 11.1]
def minConcentracion(M):
  assert type(M) == list
  # creamos una lista vacia, donde iremos agregando el minimo de cada zona
  listaC = []
  for zona in M:
    # vamos a obtener la menor medición. 
    menor = 101
    # para cada medición en la zona
    for med in zona:
    # si no es erronea
      if med != 'F':
        if med < menor:
          menor = med
    if menor != 101:
      listaC.append(menor)
    else:
      listaC.append('F')
  return listaC
# Test
assert minConcentracion(matrizTox) == [20.1, 18.3, 11.1, 11.1]
assert minConcentracion(matrizE) == [20.1, 'F', 18]

# parte 3
# maxConcentracion: list(list(num|str)) -> list(num|str)
# revisa una matriz de mediciones, y calcula el valor maximo en cada fila
# Ej: maxConcentracion(MatrizTox) entrega [30.5, 30.1, 30, 30]
def maxConcentracion(M):
  assert type(M) == list
  listaC = []
  for zona in M:
    # vamos a obtener la mayor medición. Partimos con una medición "mayor", tal
    # que sea siempre menor a cualquier dato de la matriz, con tal de que sea
    # reemplazada facilmente
    mayor = -1
    # para cada medición en la zona
    for med in zona:
    # si no es erronea
      if med != 'F':
        if med > mayor:
          mayor = med
    if mayor != -1:
      listaC.append(mayor)
    else:
      listaC.append('F')
  return listaC
# Test
assert maxConcentracion(matrizTox) == [30.5, 30.1, 30, 30]
assert maxConcentracion(matrizE) == [30.5, 'F', 30.1]

"""### Pregunta 4, strings contenidos

Se le pide crear una función contieneString(s1, s2), que recibe una frase y un string corto, donde debe decirnos si es que el string s2 esta contenido en s1, para esto debe ignorar los espacios que puedan estar en la frase s1. Además se asume que, solo importara que los caracteres coincidan, sin importar si son mayusculas o minusculas.
Por ejemplo: 
```python
contieneString("hola como estas", "laco") retorna True
```
"""

# contieneString: str str -> Bool
# Nos dice si el segundo string entregado esta contenido en alguna parte del
# primer string
# Ejemplo de uso: contieneString("hola como estas", "laco") entrega True

def contieneString(s1, s2):
  # Como debemos ignorar los espacios lo primero que haremos sera, quitar
  # todos los posibles espacios existentes en ambos strings
  s1_sin_espacios = s1.replace(" ", "")
  s2_sin_espacios = s2.replace(" ", "")
  # Además nos dicen que solo importan los caracteres por lo que
  # en caso de existir mayusculas debemos comparar por el mismo tipo
  # asi que pasaremos todo el texto a minuscula
  s1_minus = s1_sin_espacios.lower()
  s2_minus = s2_sin_espacios.lower()
  # ahora que tenemos los tring sin espacios y en minusculas
  # podemos preguntar directamente si uno esta en el otro
  return s2_minus in s1_minus

assert contieneString("Hola Como Estas", "laco")
assert contieneString("Hola Como Estas", "LaCo")
assert not contieneString("Hola Como Estas", "lace")
assert contieneString("Hola Como Estas", "la co")