# -*- coding: utf-8 -*-
"""Pauta_Auxiliar_10.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1U3UtGkxhYy2cn0EVxnOikCTq4Fm0apAB

# Pauta Auxiliar 10
## Estructuras Mutables y Listas de Python

### P1 ONU

La ONU requiere su ayuda manteniendo un registro de los países del mundo.
Para esto le solicitan a usted que cree la estructura país, la cual permite almacenar el nombre, continente y número de habitantes de un país.

##### A) Cree la estructura 'Pais' con los atributos necesarios.
"""

import estructura
# Pais: nombre(string) continente(string) habitantes(int)
estructura.crear("Pais", "nombre continente habitantes")

"""##### B) Cree la estructura mutable PaisMut con los atribuos necesarios."""

# PaisMut: nombre(string) continente(string) habitantes(int)
estructura.mutable("PaisMut", "nombre continente habitantes")

"""##### C) Defina la función cambiarHabitantes, que recibe un Pais y una cantidad de habitantes y actualiza la cantidad de habitantes del Pais en cuestión."""

#cambiarHabitantes: Pais, int -> Pais
#Cambia la cantidad de habitantes del pais por n
#Ej: cambiarHabitantes(Pais("Chile", "America", 1), 100) entrega Pais("Chile", "America", 100)
def cambiarHabitantes(pais, n):
  return Pais(pais.nombre, pais.continente, n)

assert cambiarHabitantes(Pais("Chile", "America", 1), 100) == Pais("Chile", "America", 100)

"""##### D) Defina la función cambiarHabitantesMut, que recibe un PaisMut y una cantidad de habitantes y actualiza la cantidad de habitantes del PaisMut en cuestión."""

#cambiarHabitantesMut: PaisMut, int -> None
#efecto: Cambia la cantidad de habitantes del pais por n
#Ej: cambiarHabitantesMut(PaisMut("Chile", "America", 1), 100) muta pais a PaisMut("Chile", "America", 100)
def cambiarHabitantesMut(pais, n):
  pais.habitantes = n
  
pais = PaisMut("Chile", "America", 1)
cambiarHabitantesMut(pais, 100)
assert pais == PaisMut("Chile", "America", 100)

"""##### E) Defina la función cantidadHabitantes, la cual toma como argumento un Pais y retorna la cantidad de habitantes que posee."""

#cantidadHabitantes: Pais -> int
#Entrega la cantidad de habitantes del pais
#Ej cantidadHabitantes(Pais("Chile", "America", 100)) -> 100
def cantidadHabitantes(pais):
  return pais.habitantes

assert cantidadHabitantes(Pais("Chile", "America", 100))

"""#### F) Defina la función cantidadHabitantesMut, la cual toma como argumento un Pais y retorna la cantidad de habitantes que posee."""

#cantidadHabitantes: PaisMut -> int
#Entrega la cantidad de habitantes del pais
#Ej cantidadHabitantesMut(PaisMut("Chile", "America", 100)) -> 100
def cantidadHabitantesMut(pais):
  return cantidadHabitantes(pais)

assert cantidadHabitantesMut(PaisMut("Chile", "America", 100)) == 100

"""### P2 Listas Mutables

##### A) Defina una estructura mutable (lista) que corresponda a una lista mutable.
"""

# lista: valor(any) siguiente(lista)
estructura.mutable("lista", "valor siguiente")

"""##### B) Cree la función concatenar, que reciba como parámetros una lista A, una lista B y modifique la lista A para que sea la concatenación de A y B. La función no debe retornar nada."""

#concatenar: lista, lista -> None
#efecto: Muta la primera lista para que sea la concatenacion de ambas
#Ej concatenar(lista(1,None), lista(2,None)) hace que la primera lista valga lista(1,lista(2,None))
def concatenar(l1, l2):
  if l1 == None:
    l1 = l2
  
  elif l1.siguiente == None:
    l1.siguiente = l2
  
  else:
    concatenar(l1.siguiente, l2)
    
l1 = lista(1, lista(2, None))
l2 = lista(4, lista(6,None))
concatenar(l1,l2)
assert l1 == lista(1, lista(2, lista(4, lista(6, None))))

"""##### C) Cree la función 'EliminarDesde' que recibe una lista mutable, un número de índice entero positivo y elimine todos los elementos a partir del índice de la lista retornando una lista con los elementos eliminados.

*Indicación: como n es entero positivo, no puede eliminarse toda la lista*
"""

#eliminarDesde: lista, int -> lista
#efecto: elimina los elementos desde la posición n (entero positivo) en adelante de la lista L
# Ej: eliminarDesde(lista(1,None), 0) -> lista(1,None) y la lista ahora es vacía
def eliminarDesde(L, n):
  if L == None:
    return None

  if n == 1:
    borrados = L.siguiente
    L.siguiente = None
    return borrados
  
  return eliminarDesde(L.siguiente, n-1)

l1 = lista(1,lista(2,None))
assert eliminarDesde(l1, 1) == lista(2,None)
assert l1 == lista(1,None)

"""### P3

Escribir las instrucciones para:

**A)** Definir una lista con la cantidad de días de cada mes (sin considerar años bisiestos). Ej:[31,28,…,31]

**B)** Definir una lista con los nombres de los meses Ej: [“enero”,…]

**C)** Calcular y mostrar el total de días del año

**D)** Mostrar el número del mes con menos días

**E)** Mostrar los números de los meses más largos (con más días)

**F)** Mostrar la lista de meses con sus días (ordenados cronológicamente)

**G)** Una función (masCorto) que reciba las dos listas (nombres y cantidad de días) y devuelva el nombre del mes más corto (asuma que solo existe 1)

**H)** Una función (masLargos) que reciba las dos listas y devuelva una lista con los nombres de los meses más largos (puede existir mas de uno)
"""

#Parte A
L = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]

#Parte B
M = ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]

#Parte C
total_dias = 0
for i in L:
    total_dias += i
print(total_dias)

#Parte D
print(min(L))

#Parte E
print(max(L))

#Parte F
for i in range(len(L)):
    print(M[i], L[i])

#Parte G
#masCorto: lista<int> lista<String> -> String
#Entrega el nombre del mes mas corto.
#Ej: masCorto(L, M) == "febrero"
def masCorto(L, M):
    for i in range(len(L)):
        if L[i] == min(L):
            return M[i]

assert masCorto(L, M) == "febrero"

#Parte H
#masLargos: lista<int> lista<String> -> lista<String>
#Entrega lista con los nombres de los meses mas largos.
#Ej: masLargos(L, M) == ['enero', 'marzo', 'mayo', 'julio', 'agosto', 'octubre', 'diciembre']
def masLargos(L, M):
    resp = []
    for i in range(len(L)):
        if L[i] == max(L):
            resp.append(M[i])
    return resp

assert masLargos(L, M) == ['enero', 'marzo', 'mayo', 'julio', 'agosto', 'octubre', 'diciembre']