# -*- coding: utf-8 -*-
"""Pauta Auxiliar 9.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1kL79k4j8-eilQyL1dM_a1s31DJuP_tLO

# Auxiliar 9
### Árboles binarios (AB) y Árboles de Búsqueda Binaria (ABB)
Auxiliares: Nadia Decar, Nelson Marambio, Albani Olvieri, Monserrat Prado, Lucas Torrealba, Ricardo Valdivia
"""

import estructura
from ABB import * 
from lista import *

"""### Pregunta 1 - Hablemos de ABs

Si A es un árbol, escriba las siguientes funciones con sus tests correspondientes (usa los árboles definidos a continuación):
"""

A = AB(5, AB(6, AB(3,None,None), AB(2,None,None)), AB(1, AB(4,None,None),None))
B = AB(10, AB(8, AB(6, AB(5, None, None), None), None), AB(15, AB(11, None, None), AB(20, None, None)))
C = AB(4, AB(2,AB(1,None,None),AB(3,None,None)), AB(6,AB(5,None,None),None))

# esAB: any -> bool
# True si la estructura es AB
#ej: esAB(AB(1,None,None))->True
def esAB(A):
    return A==None or type(A)==AB
assert esAB(AB(1,None,None))

# aLista: AB -> lista
# lista con valores de arbol izquierdo, valor y valores del arbol derecho
# ej: aLista(A) -> lista(3, lista(6, lista(2, lista(5, lista(4, lista(1, None))))))
def aLista(AB, listaFinal = listaVacia):
    if(AB == None):
        return listaFinal
    else:
        listaFinal = aLista(AB.der, listaFinal)
        listaFinal = lista(AB.valor, listaFinal)
        listaFinal = aLista(AB.izq, listaFinal)
        return listaFinal
assert aLista(A) == lista(3, lista(6, lista(2, lista(5, lista(4, lista(1, None))))))

"""##Pregunta 2 - Agenda Telefónica 

En esta pregunta simularemos una agenda telefónica en formato ABB, por lo que cada valor del árbol será una persona (que tiene nombre, apellido y número telefónico). Usted debe considerar que el árbol se ordena en base al apellido de la persona, si dos personas tienen el mismo apellido entonces habrá que ordenar en base al nombre. Además, no habrán dos personas con mismo nombre y apellido en la agenda telefónica.

En base a lo anterior, usted deberá programar 3 funciones que permitirán simular ciertas funcionalidades de una agenda telefónica:


1.   Cree la estructura *Persona*, la cual debe tener *nombre*, *apellido* y *telefono*
2.   Cree la función ***listaTelefonicaPorApellido(abb, apellido)*** que retorna una lista enlazada ordenada con todos los contactos (personas) que tengan dicho apellido.
3.   Cree la función ***ConsultarTelefono(abb, apellido, nombre)***, que dado el nombre y apellido de una persona retorne el número telefónico de dicha persona.


"""

# 1.

# Persona: nombre(str) apellido(str) telefono(str)
estructura.crear('Persona', 'nombre apellido telefono')

# 2.

# listaTelefonicaPorApellido: AB str -> list(Persona)
# Retorna todos los contactos que tengan cierto apellido
# Ej.: sea A = AB(Persona('Juan', 'Perez', '123'), None, None)
# listaTelefonicaPorApellido(A, 'Perez') debe retornar 
# crearLista(Persona('Juan', 'Perez', '123'), listaVacia)

def listaTelefonicaPorApellido(abb, apellido, newLista=listaVacia):
  if abb == None:
    return newLista
  newLista = listaTelefonicaPorApellido(abb.der, apellido, newLista)
  if abb.valor.apellido == apellido:
    newLista = crearLista(abb.valor, newLista)
  return listaTelefonicaPorApellido(abb.izq, apellido, newLista)


# Tests 
p1 = Persona('Juanita', 'Perez', '12345')
p2 = Persona('Juan', 'Castro', '12367')
p3 = Persona('Manuel', 'Castro', '12333')
p4 = Persona('Alejandro', 'Muñoz', '125445')
p5 = Persona('Luis', 'Rodriguez', '125445')
p6 = Persona('Luchita', 'Abarca', '125445')

A = AB(p1, AB(p4, AB(p2, AB(p6, None, None), AB(p3, None, None)), None), AB(p5, None, None))

assert listaTelefonicaPorApellido(A, 'Castro') == crearLista(p2, crearLista(p3, listaVacia))
assert listaTelefonicaPorApellido(A, 'Abarca') == crearLista(p6, listaVacia)
assert listaTelefonicaPorApellido(A, 'Pereira') == listaVacia
assert listaTelefonicaPorApellido(None, 'Pereira') == listaVacia

# 3. 

# consultarTelefono: AB str str -> str
# Retorna el numero telefono de una persona
# Ej.: sea A = AB(Persona('Juan', 'Perez', '123'), None, None)
# consultarTelefono(A, 'Perez', 'Juan') debe retornar '123'

def consultarTelefono(abb, apellido, nombre):
  if abb == None:
    return ''
  if abb.valor.apellido == apellido and abb.valor.nombre == nombre:
    return abb.valor.telefono
  elif abb.valor.apellido > apellido:
    return consultarTelefono(abb.izq, apellido, nombre)
  elif abb.valor.apellido < apellido:
    return consultarTelefono(abb.izq, apellido, nombre)
  else:
    if abb.valor.nombre > nombre:
      return consultarTelefono(abb.izq, apellido, nombre)
    elif abb.valor.nombre < nombre:
      return consultarTelefono(abb.der, apellido, nombre)


# Tests
p1 = Persona('Juanita', 'Perez', '12345')
p2 = Persona('Juan', 'Castro', '12367')
p3 = Persona('Manuel', 'Castro', '12333')
p4 = Persona('Alejandro', 'Muñoz', '125445')
p5 = Persona('Luis', 'Rodriguez', '125445')
p6 = Persona('Luchita', 'Abarca', '125445')

A = AB(p1, AB(p4, AB(p2, AB(p6, None, None), AB(p3, None, None)), None), AB(p5, None, None))

assert consultarTelefono(A, 'Castro', 'Juan') == '12367'
assert consultarTelefono(A, 'Castro', 'Manuel') == '12333'
assert consultarTelefono(A, 'Abarca', 'Luchita') == '125445'
assert consultarTelefono(A, 'Castro', 'Pamela') == ''
assert consultarTelefono(None, 'Zuñiga', 'Luis') == ''

"""## Pregunta 3 - Dulces 
En una pastelería tienen un recuento de los distintos pasteles que tienen en stock. Estos son almacenados en una estructura llamada "Pasteles", la cual tiene los siguientes atributos: Nombre, Precio, Stock. La persona que maneja el local consiguió que alguien le ordenara los pasteles en un ABB según el precio, pero no sabe manejarlo, para ayudarle siga los siguientes pasos. 

1. Cree la estructura "Pasteles"
2. Cree la función CantidadTiposPasteles, que reciba un ABB y retorne la cantidad de pasteles distintos que posee. (Asuma que no hay dos estructuras con el mismo Nombre). 
3. Cree la función BusquedaPastel, que reciba el Nombre de un pastel y un ABB de pasteles, e imprima Precio y Stock de los pasteles, de forma clara. Asuma que el pastel que se está buscando siempre va a estar en el ABB.
4. Cree la función MasBarato, que reciba un precio y un ABB de pasteles, y retorne una lista con los nombres de los pasteles cuyos precios son menores o iguales al indicado. Hint: Cree la función auxiliar UneListas, que toma dos listas y las une.

*Nota: Recuerde hacer las recetas de diseño para todo lo pedido y sus tests correspondientes (use las estructuras y árboles proporcionados)*

*Nota2: Recuerda la diferencia entre imprimir y retornar* 
"""

# 1.

#Pasteles: Nombre(str) Precio(int) Stock(int)
estructura.crear("Pasteles", "Nombre Precio Stock")

# 2. 

pas1 = Pasteles("Pie de Limon", 1400, 5)
pas2 = Pasteles("Milhojas" , 700, 12)
pas3 = Pasteles("Macarron", 300, 30)
pas4 = Pasteles("Kuchen de Nuez", 2500, 1)
pas5 = Pasteles("Pastel de queso", 900, 22)

a1 = AB(pas5, AB(pas3, None, AB(pas2, None, None)), AB(pas1, None, AB(pas4, None, None)))
a2 = AB(pas3, None, AB(pas1, AB(pas2, None, None), None))

#CantidadTiposPasteles: AB -> int
#retorna la cantidad de pasteles distintos que posee el ABB
#Ej: CantidadTiposPasteles(a1) retorna 5
def CantidadTiposPasteles(A): 
  if A == None: 
    return 0
  else: 
    return 1 + CantidadTiposPasteles(A.izq) + CantidadTiposPasteles(A.der)

#Tests
assert CantidadTiposPasteles(a1) == 5
assert CantidadTiposPasteles(a2) == 3

# 3.

#BusquedaPastel: str AB -> None
#imprime el precio y el stock del pastel que se busca 
#Ej: BusquedaPastel("Macarron", a1) imprime "El precio es: 300 \n Hay 30 disponibles"
def BusquedaPastel(nombre, A):
  if A == None: 
    return 
  cabeza = A.valor
  if nombre==cabeza.Nombre: 
    print("El precio es:", cabeza.Precio)
    print("Hay", cabeza.Stock, "disponibles") 
  else: 
    BusquedaPastel(nombre, A.izq)
    BusquedaPastel(nombre, A.der)

# Test 
BusquedaPastel("Macarron", a1)

# 4.

#UneListas: lista lista -> lista 
#Toma dos listas y las une 
#Ej: UneListas(lista(1, lista(2, listaVacia)), lista(3, lista(4, listaVacia))) == lista(1, lista(2, lista(3, lista(4, listaVacia))))
def UneListas(l1, l2): 
  if l1 == listaVacia: 
    return l2
  else: 
    return lista(cabeza(l1), UneListas(cola(l1), l2))

#Test
l1 = lista(1, lista(2, listaVacia))
l2 = lista(3, lista(4, listaVacia))
l3 = lista('hola', lista('chao', listaVacia))
assert UneListas(l1,l2) == lista(1, lista(2, lista(3, lista(4, listaVacia))))
assert UneListas(l2,l1) == lista(3, lista(4, lista(1, lista(2, listaVacia))))
assert UneListas(l1, l3) == lista(1, lista(2, lista('hola', lista('chao', listaVacia))))

pas1 = Pasteles("Pie de Limon", 1400, 5)
pas2 = Pasteles("Milhojas" , 700, 12)
pas3 = Pasteles("Macaroon", 300, 30)
pas4 = Pasteles("Kuchen de Nuez", 2500, 1)
pas5 = Pasteles("Pastel de queso", 900, 22)

a1 = AB(pas5, AB(pas3, None, AB(pas2, None, None)), AB(pas1, None, AB(pas4, None, None)))
a2 = AB(pas3, None, AB(pas1, AB(pas2, None, None), None))

#MasBarato: int AB -> lista
#retorna una lista con los nombres de los pasteles cuyo precio es menor o igual que el ingresado 
#Ej: MasBarato(1000, a1) entrega lista('Pastel de queso', lista('Macaroon', lista('Milhojas', listaVacia)))
def MasBarato(p, A):  
  if A == None: 
    return listaVacia
  else: 
    cabeza = A.valor
    l1 = MasBarato(p, A.izq)
    l2 = MasBarato(p, A.der)
    if cabeza.Precio <= p:
      juntar = UneListas(l1,l2)
      return lista(cabeza.Nombre, juntar)
    else: 
      return UneListas(l1,l2)
      
#Tests
assert MasBarato(1000, a1) == lista('Pastel de queso', lista('Macaroon', lista('Milhojas', listaVacia)))
assert MasBarato(800,a1) == lista('Macaroon', lista('Milhojas', listaVacia))
assert MasBarato(200, a2) == listaVacia
assert MasBarato(300, a2) == lista(pas3.Nombre, listaVacia)

"""##Pregunta 4 - Expresiones lógicas 

Una expresión lógica se puede representar por un árbol binario. Por ejemplo, p and not (q or r) se representa por:
```
       “and” 		
    /           \		
 p             “not”		
                       \		  
                     “ or”	
                   /        \	  
                q            r

```

Notas:

- p, q y r son variables de tipo bool (con valores True o False).
- Los valores de las hojas del árbol son True o False (de tipo bool) y los otros valores son los strings “and”, “or” o “not”.
- En caso del operador “not”, el operando se guarda en el árbol derecho (y el izquierdo está vacío).

A) Escriba todas las instrucciones que se necesitan para definir el árbol binario indicado en el ejemplo  anterior. Al respecto, asigne valores a las variables p, q y r de manera que el resultado de la expresión lógica sea True.

B) Escriba una función (incluyendo receta de diseño y testing) que reciba un árbol binario que representa una expresión lógica válida, la evalúe y devuelva el resultado (True o False)

"""

# A.
                    
estructura.crear("AB","valor izq der")  

p=True                                  
q=False                                 
r=False                                 
A=AB("and", \
     AB(p,None,None), \
     AB("not",None, \
        AB("or",AB(q,None,None),AB(r,None,None))))

# B.

# evaluar: AB -> bool                        
# evalua expresion lógica representada en A 
# ej: evaluar(A) -> True                   
def evaluar(A): 
    v = A.valor    
    if A.izq==None and A.der==None:
        return v                    
    if v=="and":                             
        return evaluar(A.izq) and evaluar(A.der)
    if v=="or":                                
        return evaluar(A.izq) or evaluar(A.der)
    if v=="not": 
        return not evaluar(A.der)
#Test               
assert evaluar(A) #evaluar(A)==True