# -*- coding: utf-8 -*-
"""Auxiliar5_pauta.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1Upy82KYOWZd0E9x2eKpY1eI-QuLio3IY

# Auxiliar 5
### Estructuras y listas recursivas
Auxiliares: Nadia Decar, Nelson Marambio, Albani Olvieri, Monserrat Prado, Lucas Torrealba, Ricardo Valdivia

### P1 - Kino
El Kino es un popular juego de lotería chileno que consiste en elegir 14 números del 1 al 25 (distintos)
y recibir un premio en función de un sorteo aleatorio. A continuación crearemos un programa para jugar Kino, siguiendo estos pasos:

a)   Cree la estructura Kino, la cual consta de una lista de 14 enteros (del 1 al 25, sin repetición y ordenada ascendentemente) y un string Comprador que representa de quien efectuó la compra.

b) Cree la función xEstaEnL(x,L) que verifique si el numero x esta en la lista L.

c) Cree la funcion numerosGanadores() que entregue un lista con 14 numeros  distintos, los que corresponderán a los numeros ganadores del Kino.

d) Cree la funcion numerosIguales(L1,L2) que recibe dos listas y entrega la cantidad de numeros de la lista 1 que estan en la lista 2.

e) Cree la función imprimirLista(L), que imprima todos los elementos de una lista.

f) Cree la función sortearKino(L) que, recibiendo una lista de Kinos, simule un sorteo aleatorio del Kino e imprima lo siguiente: 

*   Si un Kino coincide con entre 14 y 10 números, debe imprimir en pantalla ’Premio X’ (si coincide con 14 números, la función muestra ’Premio 1’, si coincide con 13 muestra ’Premio 2’ y así hasta el 5to premio), junto con el nombre de el/los ganadores
*   En cualquier otro caso la función muestra "No hay ganadores".

Por ejemplo (caso con varios ganadores):

    listaConocida = lista(Kino1,...)
    sortearKino(listaConocida)
    Premio 1 Elmer Figueroa
    Premio 3 Luis Miguel Gallego
"""

import estructura as es
from lista import * 

# Kino: numeros(lista) comprador(str)
es.crear('Kino','numeros comprador')

# xEstaEnL : int lista(int) -> bool
# True si x es parte de la lista L, False si no
# por ejemplo xEstaEnL(1, lista(2,lista(1,None))) retorna True
def xEstaEnL(x,L):
    if L == None: 
      return False
    if cabeza(L) == x: 
      return True
    return xEstaEnL(x,cola(L))

# test
assert xEstaEnL(1,lista(2,lista(1,None)))

# numerosGanadores : None -> lista(int)
# retorna lista de 14 numeros aleatorios sin repeticion
def numerosGanadores(listaParcial = None, cont1 = 0):
    if cont1 == 14:
        return listaParcial
    enteroAleatorio = random.randint(1,25)
    if xEstaEnL(enteroAleatorio,listaParcial):
        return numerosGanadores(listaParcial, cont1)
    else:
        return numerosGanadores(lista(enteroAleatorio,listaParcial),cont1 + 1)

# numerosIguales: lista(int) lista(int) -> int
# retorna cuantos elementos de L1 estan en L2
# por ejemplo numerosIguales(lista(1,lista(2,None)), lista(2,None)) retorna 1
def numerosIguales(L1, L2):
    if L1 == None: 
      return 0
    if xEstaEnL(cabeza(L1),L2): 
      return 1 + numerosIguales(cola(L1),L2)
    return numerosIguales(cola(L1),L2)

# test
L = crearLista(1,crearLista(2,crearLista(3,\
                            crearLista(4,crearLista(5,lista(6,crearLista(7,\
                                crearLista(8,crearLista(9,crearLista(10,crearLista(11,\
                                      crearLista(12,crearLista(13,crearLista(14,None))))))))))))))
L1 = crearLista(15,crearLista(20,crearLista(18,\
                            crearLista(21,crearLista(17,lista(24,crearLista(7,\
                                crearLista(8,crearLista(9,crearLista(23,crearLista(11,\
                                      crearLista(12,crearLista(13,crearLista(14,None))))))))))))))
assert numerosIguales(L,L1) == 7

# imprimirLista : lista(str) -> None
# imprime en pantalla una lista de strings (cada elemento en una linea)
def imprimirLista(L):
    if L == None: return
    print(cabeza(L))
    return imprimirLista(cola(L))

# sortearKino : lista(Kino) -> None
# sortea un juego de Kino y muestra los ganadores de una lista de Kinos
def sortearKino(L, numerosSorteados = None, listaGanadores = None):
    if numerosSorteados == None:
        numerosSorteados = numerosGanadores()
    if vacia(L):
        if listaGanadores == None:
            print ("No hay ganadores")
            return
        else:
            imprimirLista(listaGanadores)
            return 
    assert type(L) == lista
    assert type(cabeza(L)) == Kino
    n = numerosIguales(numerosSorteados, cabeza(L).numeros)
    if  n == 14:
        listaGanadores = lista("Premio 1 " + cabeza(L).comprador, listaGanadores)
        return sortearKino(cola(L),numerosSorteados, listaGanadores)
    elif n == 13:
        listaGanadores = lista("Premio 2 " + cabeza(L).comprador, listaGanadores)
        return sortearKino(cola(L),numerosSorteados,listaGanadores)
    elif n == 12:
        listaGanadores = lista("Premio 3 " + cabeza(L).comprador, listaGanadores)
        return sortearKino(cola(L),numerosSorteados,listaGanadores)
    elif n == 11:
        listaGanadores = lista("Premio 4 " + cabeza(L).comprador, listaGanadores)
        return sortearKino(cola(L),numerosSorteados,listaGanadores)
    elif n == 10:
        listaGanadores = lista("Premio 5 " + cabeza(L).comprador, listaGanadores)
        return sortearKino(cola(L),numerosSorteados, listaGanadores)
    return sortearKino(cola(L),numerosSorteados,listaGanadores)

# test:
import random
L = lista(1,lista(2,lista(3,lista(4,lista(5,lista(6,lista(7,lista(8,lista(9,lista(10,lista(11,lista(12,lista(13,lista(14,None))))))))))))))
Kino1 = Kino(L,"Luis Miguel")
listaKinos = lista(Kino1,None)
sortearKino(listaKinos)

"""### P2 - Palíndromos

Un palíndromo es una palabra o frase que puede leerse de la misma forma de izquierda a derecha y viceversa. Por ejemplo, "reconocer", "anilina" o el clásico "Anita lava la tina" cumplen con esta definición.

Este tipo de palabras han empezado a despertar la curiosidad de un amigo suyo, que quiere saber a quien le gustaría saber rápidamente si una secuencia de caracteres es palíndromo. Él sabe que usted está tomando un curso de programación y que puede hacer cosas bacanes, así que le pide ayuda.

Para esto, considere que una palabra puede ser escrita a través de una lista recursiva, donde cada elemento de la lista corresponde a una letra. 

a) Cree la función voltear, que recibe una lista recursiva y entrega otra lista cuyos elementos son los mismos que la primera pero en orden invertido.

b) Cree la función palindromo, que recibe una lista recursiva que representa una palabra y entrega si la palabra es palíndroma o no.
"""

# voltear: lista(string) -> lista(string)
# entrega una lista como la que recibe como entrada
# pero con los elementos en orden invertido
# ej: L = lista("h", lista("o", lista("l", lista("a", None))))
# voltear(L) retorna lista("a", lista("l", lista("o", lista("h", None))))
def voltear(L, listaInversa = None):
  if L == listaVacia:
    return listaInversa
  else:
    return voltear(cola(L), crearLista(cabeza(L), listaInversa))

# test
L1 = lista("h", lista("o", lista("l", lista("a", None))))
assert voltear(L1) == lista("a", lista("l", lista("o", lista("h", None))))

# palindromo: lista(string) -> boolean
# retorna si una palabra es palíndroma o no
# ej: tomando el L de la receta de voltear
# palindromo(L) retorna False
def palindromo(L):
  if L == voltear(L):
    return True
  else:
    return False

# tests
L2 = lista("a", lista("n", lista("i", lista("l", lista("i", lista("n", lista("a", None)))))))
assert palindromo(L2) == True
assert palindromo(L1) == False

"""### P3 - Hora de un control
En un tiempo ya lejano, cuando existía la presencialidad y éramos más felices y no lo sabíamos (:se pone a llorar:), existía un problema bastante común en la facultad que era determinar la hora a la cual terminaba un control. En aquellos tiempos remotos, se tenía que hacer a mano. Ahora vamos a usar el poder de Python para resolver este problema.

a) Cree la estructura Tiempo, la cual consta de 2 enteros: uno para indicar la hora y otro para indicar los minutos.

b) Cree la función formatoTiempo(t) que, dado un tiempo, retorna el string que lo representa en formato HH:MM. Note que si los minutos tienen 1 digito debe anteponer un 0.

c) Cree la función sumarTiempo(t1, t2) que, dado 2 tiempos, los suma. Si el resultado de las horas es mayor o igual a 24 entonces vuelve a 0.

d) Finalmente cree un programa para determinar el tiempo final de un control, dados su hora de inicio y su duración.

```
ti hora: 18
ti mins: 16
dt hora: 2
dt mins: 15
El control termina a las 20:31
```



"""

# Tiempo: hora(int) minutos(int)
es.crear("Tiempo", "hora minutos")

# formatoTiempo: Tiempo -> str
# retorna el string que representa un tiempo en formato HH:MM
# ej: formatoTiempo(Tiempo(9, 45)) retorna "9:45"
def formatoTiempo(t):
  hhmm = str(t.hora) + ":"
  if t.minutos < 10:
    hhmm = hhmm + "0" + str(t.minutos)
  else:
    hhmm = hhmm + str(t.minutos)
  return hhmm

# tests
t1 = Tiempo(9, 45)
t2 = Tiempo(18, 0)
assert formatoTiempo(t1) == "9:45"
assert formatoTiempo(t2) == "18:00"

# sumarTiempo: Tiempo Tiempo -> Tiempo
# suma 2 tiempos
# ej: formatoTiempo(Tiempo(18, 0), Tiempo(3, 0)) retorna Tiempo(21, 0)
def sumarTiempo(t1, t2):
  minutos = t1.minutos + t2.minutos
  horas = 0
  if minutos >= 60:
    horas += 1
    minutos %= 60
  horas = (horas + t1.hora + t2.hora) % 24
  sumaTiempos = Tiempo(horas, minutos)
  return sumaTiempos

# tests
t3 = Tiempo(1, 30)
assert sumarTiempo(t1, t2) == Tiempo(3, 45)
assert sumarTiempo(t1, t3) == Tiempo(11, 15)

# programa
tihora = int(input("ti hora: "))
timinutos = int(input("ti minutos: "))
dthora = int(input("dt hora: "))
dtminutos = int(input("dt minutos: "))
ti = Tiempo(tihora, timinutos)
dt = Tiempo(dthora, dtminutos)
tf = sumarTiempo(ti, dt)
print("El control termina a las", formatoTiempo(tf))

"""![external-content.duckduckgo.com.png](data:image/png;base64,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)"""