# -*- coding: utf-8 -*-
"""Pauta Auxiliar 4.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1fOp9XVGh96apgGO6jnWpcPtagQ1-LcH3

# Pauta Auxiliar 4
## Profesores : Alejandro Hevia, Bárbara Poblete
### Auxiliares: Albani Olivieri, Lucas Torrealba, Monserrat Prado, Nadia Decar, Nelson Marambio, Ricardo Valdivia

####P1 Calculo de Divisores

Para esta pregunta se le solicita, crear una función que cacule la cantidad de divisores que tienen un numero entero, para esto se le pide que la realice utilizando **obligatoriamente** al menos una variable por omisión.
"""

# divisores: int -> int
# función que entrega cuantos divisores tiene un numero dado
# Ej: divisores(12) entrega 6
def divisores(n, actual=1):
  # usamos una variable por omisión para recordar cual es el divisor actual que estamos
  # probando, partiendo inicialmente de 1
  # caso base: si el divisor actual a probar, es el mismo numero, entonces es divisor, y
  # a la vez terminamos la recursión.
  if n==actual:
    return 1
  # caso recursivo: vemos si el divisor actual divide o no al numero.
  else:
    if n%actual == 0:
    # si lo divide, entonces contamos un divisor y lo sumamos a los divisores
    # que se encuentren mas adelante. Se incrementa la variable del divisor actual.
      return 1 + divisores(n,actual+1)
    else:
    # si no lo divide, entonces seguimos buscando divisores
    # que se encuentren mas adelante. Se incrementa la variable del divisor actual.
      return divisores(n, actual+1)
# Test
assert divisores(12) == 6
assert divisores(3) == 2
assert divisores(24) == 8

"""#### P2 Polinomios de Hermite

Escriba un programa que calcule el polinomio de Hermite según el grado y punto que se le
indique.
Todos los polinomios de Hermine de orden n > 2 se pueden expresar de la siguiente forma


$$H_n(x) = 2x · H_{n−1}(x) − 2(n − 1)H_{n−2}(x)$$

con $H_0(x) = 1$ y $H_1(x) = 2x$
Los primeros serán de la forma:

- $H_0(x)=1$
- $H_1(x)=2x$
- $H_2(x)=4x^2 - 2$
- $H_3(x)=8x^3 - 12x$
- $H_4(x)=16x^4 - 48 x^2 + 12$
- $H_5(x)=32x^5 - 160x^3 + 120x$
"""

# polinomioDeHermite: int int -> int
# Calcula el polinimio de hermite de un grado dado en cierto punto.
# Ejemplo de uso polinomioDeHermite(3, 2) entrega 40

def polinomioDeHermite(grado, punto):
  # Definimos los 2 casos bases que nos entregan por el enunciado, con el fin
  # de poder obtener la recursion correcta por definición.
  if grado == 0:
    return 1
  elif grado == 1:
    return 2 * punto
  else:
  # luego hacemos los llamados recursivos, tal como lo indica la formula general
  # del enunciado
    return 2 *punto * polinomioDeHermite(grado-1, punto) - (2 * (grado-1) * polinomioDeHermite(grado-2, punto))



assert polinomioDeHermite(3, 1) == -4
assert polinomioDeHermite(3, 2) == 40
assert polinomioDeHermite(4, 2) == 76
assert polinomioDeHermite(4, 1) == -20

"""####P3 Mayor dato

Escriba una funcion recursiva, que devuelva el mayor de un lista de números que termina con un número negativo.
`Hint: Utilice variables por omisión` 

La función debe establecer un diálogo como el que se muestra en el siguiente 
ejemplo:

```python
>>>mayor()
n°? 2
n°? 3
n°? 1
n°? -1    # fin de los datos
3        # resultado de la función
```
Para esta función no debe realizar test.

"""

# mayor None -> int
# Entrega el mayor número encontrado en una lista que es entregada
# por el usuario. La función retorna cuando se ingresa un numero negativo.

def mayor(max=0):
  n = int(input("n°? "))
  if (n<0):
    return max
  else:
    if (n >= max):
      return mayor(n)
    else:
      return mayor(max)

"""####P4 Potencias de Dos
Escribir la función recursiva potenciasDe2 que use la función potencia para calcular potencias de 2 enteras >=0 a través del siguiente diálogo:

```python
>>>potenciasDe2()
potencia? 4
resultado = 16
potencia? 10
resultado = 1024
potencia? 0
resultado = 1
…
potencia?-1 (Una potencia negativa termina el programa)
``` 

Función potencias vista en clases:

```python
# potencia: num int -> num
# calcula el valor de una potencia de base elevado a exponente
# para exponentes enteros positivos
# ejemplo: potencia (4,5) debe dar 1024
def potencia(base, exponente):
    if exponente == 0:
        return 1
    else:
        return base*(potencia(base, exponente-1))

# test
assert potencia(4,5) == 1024
assert potencia(2,4) == 16
assert potencia(-1,5) == -1
assert potencia(3,0) == 1
```
"""

# potencia: num int -> num
# calcula el valor de una potencia de base elevado a exponente
# para exponentes enteros positivos
# ejemplo: potencia (4,5) debe dar 1024
def potencia(base, exponente):
    if exponente == 0:
        return 1
    else:
        return base*(potencia(base, exponente-1))

# test
assert potencia(4,5) == 1024
assert potencia(2,4) == 16
assert potencia(-1,5) == -1
assert potencia(3,0) == 1

#potenciasDe2: none -> none
# calcula potencias >=0 de 2.
# ejemplo: --
def potenciasDe2():
    n = int(input('potencia? '))
    if n < 0:
        return
    else:
        print("resultado =",potencia(2,n))
        potenciasDe2()