# -*- coding: utf-8 -*-
"""Pauta_Auxiliar_3.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1W4gICoKodfFm3JBpjviCh0i10R_20pkm

# Pauta Auxiliar 3
## Recursión, testing y depuración

### Pregunta 1 

Se define la función recursiva $Fun$ de la siguiente manera:

\begin{equation*}
    Fun(n) = \left \{ \begin{matrix} 1 & \mbox{si }n=1
   \\ 3 & \mbox{si } n=2 
\\ Fun(n-1) - Fun(n-2) & \mbox{si }n>2\end{matrix}\right.
\end{equation*}

Para esta pregunta usted deberá resolver el problema de encontrar $\sum_{i=1}^n Fun(i)$ recursivamente. Para esto usted implementará las siguientes **funciones recursivas**:
- Fun(x): Devuelve el resultado de la fórmula recursiva
- suma_Fun(x): Devuelve el resultado de la fórmula $\sum_{i=1}^n Fun(i)$

Ambas funciones solo reciben números enteros positivos $(>0)$ (debe verificarlo). Además, debe realizar el testing con al menos 3 casos.
"""

# fun: int -> int
# Retorna el resultado de la funcion recursiva "fun"
# Ejemplo: fun(1) retorna 1
def fun(x):
  assert type(x)==int and x>0
  if x==1:
    return 1
  elif x==2:
    return 3
  else:
    return fun(x-1)-fun(x-2)
# Test
assert fun(1)==1
assert fun(5)==-3
assert fun(15)==2

# suma_fun: int -> int
# Retorna la suma de los primeros x numeros de la sucesion "fun"
# Ejemplo: suma_fun(2) retorna 4
def suma_fun(x):
  assert type(x)==int and x>0
  if x == 1:
    return fun(x)
  else:
    return fun(x) + suma_fun(x-1)
# Test
assert suma_fun(1)==1
assert suma_fun(15)==6
assert suma_fun(20)==4

"""### Pregunta 2

Programe la función (de manera **recursiva**) que resuelva la siguiente recurrencia (debe verificar que tanto m como n sean enteros y no negativos):

\begin{equation*}
    funcion\_recursiva(m,n) = \left \{ \begin{matrix} funcion\_recursiva(m-1,n)
    +1 & \mbox{si }n=0\mbox{ y } m>0
\\ funcion\_recursiva(m,n-1)+n & \mbox{si }n>0\end{matrix}\right.
\end{equation*}

Donde $funcion\_recursiva(0,0) = 0$

Note que la $funcion\_recursiva$ es equivalente a $f(m,n) = m+ n(n+1)/2$, lo anterior le podría ser útil para los test.
"""

# funcion_recursiva: int int -> int
# Retorna el resultado de la funcion recursiva "funcion_recursiva"
# Ejemplo: funcion_recursiva(1,1) retorna 2
def funcion_recursiva(m,n):
  assert type(m)==int and type(n)==int and m >= 0 and n >= 0

  #Caso base
  if (m == 0 and n==0):
    return 0
  #Caso 1  
  elif (n==0 and m > 0):
    return funcion_recursiva(m-1, n) + 1
  # Caso 2
  else:
    return funcion_recursiva(m,n-1) + n

# Test
assert funcion_recursiva(0,0) == 0
assert funcion_recursiva(0,1) == 1
assert funcion_recursiva(5,1) == 6

"""### Pregunta 3
#### Parte A
Implemente la función `numeros_de_catalan(n)`, la cual recibe un entero no negativo $n$ y retorna el número de catalan asociado.

\begin{equation*}
    C_n = \left \{ \begin{matrix} 1 & \mbox{si }n=0
\\  \displaystyle\frac{2(2n-1)}{n+1}\cdot C_{n-1}& \text{en caso contrario}\end{matrix}\right.
\end{equation*}
"""

# numeros_de_catalan: int -> int
# Retorna el resultado de la funcion recursiva "numeros de catalan"
# Ejemplo: numeros_de_catalan(5) retorna 42
def numeros_de_catalan(n):
  assert type(n) == int and n >= 0
  if n == 0:
    return 1
  return 2*(2*n-1)/(n+1) * numeros_de_catalan(n-1)

# Test
assert numeros_de_catalan(0)==1
assert numeros_de_catalan(1)==1
assert numeros_de_catalan(5)==42
assert numeros_de_catalan(18)==477638700
assert numeros_de_catalan(25)==4861946401452

"""### Parte B
Implemente una función recursiva llamada `mcd(a,b)`, la cual calcule el máximo común divisor por el método de euclides. (Verifique que sean numeros enteros no negativos)

Método de Euclides para obtener el máximo común divisor entre A y B:
- Si B es 0 entonces el resultado es A.
- En otro caso, el resultado debe ser el máximo común divisor entre B y R. Donde R es el resto entre A y B, es decir, A=B$\cdot$k+R.


"""

# mcd_euclides: int int -> int
# Retorna el mcd entre a y b, usando el algoritmo de euclides
# Ejemplo: mcd_euclides(2,1000) retorna 2
def mcd_euclides(a,b):
  assert type(a) == int and a >= 0
  assert type(b) == int and b >= 0
  if b==0:
    return a
  return mcd_euclides(b, a%b )

# Test
assert mcd_euclides(1000,0) == 1000
assert mcd_euclides(0,1000) == 1000
assert mcd_euclides(2,1000) == 2
assert mcd_euclides(1,238231) == 1
assert mcd_euclides(7,19) == 1
assert mcd_euclides(8232,13377) == 1029

"""### Pregunta 4

### El Juego de la Oca 2.0
En la auxiliar 2, usted vio el juego de la Oca y programó la función mover:
```
# mover: int -> int
# desde la casilla actual, mueve al jugador por el tablero y entrega la casilla resultante
# ejemplo: mover(1) entrega 8 si es que la suma de los dos dados da 7
def mover(casilla, dado1, dado2):
  suma=dado1+dado2+casilla   
  if suma>63:                                 
      nuevaCasilla=63-(suma-63)  
  else:                          
      nuevaCasilla=suma          
  if nuevaCasilla==63:            
      return 63                  
  elif nuevaCasilla%9==0:         
      return nuevaCasilla + 9     
  else:                           
      return nuevaCasilla         
assert mover(1,4,3)==8
assert mover(55,5,5)==61
```
Además, posee la función tirar_datos(), la cual retorna un entero que representa la suma de 2 dados lanzados al azar.
```
import random

def lanzar_dado():
  return random.randint(1,6)
```

Su objetivo en esta pregunta será simular la partida de solo 1 jugador y devolver la cantidad de turnos que utilizó. Esto lo debe realizar implementando la función recursiva `turnos_jugados_oca(n)`, la cual recibe como parámetro la posición actual del jugador y retorna la cantidad de turnos que le llevó terminar el juego. 

*Nota: Para esta pregunta, no es necesario que realice testing debido a la aleatoriedad de los dados.*
"""

import random

# mover: int -> int
# desde la casilla actual, mueve al jugador por el tablero y entrega la casilla resultante
# ejemplo: mover(1) entrega 8 si es que la suma de los dos dados da 7
def mover(casilla, dado1, dado2):
  suma=dado1+dado2+casilla   
  if suma>63:                                 
      nuevaCasilla=63-(suma-63)  
  else:                          
      nuevaCasilla=suma          
  if nuevaCasilla==63:            
      return 63                  
  elif nuevaCasilla%9==0:         
      return nuevaCasilla + 9     
  else:                           
      return nuevaCasilla         

# Test
assert mover(1,4,3)==8
assert mover(55,5,5)==61

# lanzar_dado: -> int 
# retorna un numero entero (aleatorio) entre 1 y 6
def lanzar_dado():
  return random.randint(1,6)

# turnos_jugados_oca: int -> int
# retorna el numero de juegos que se puede dar en 
# el juego de la oca a partir de la posicion n
def turnos_jugados_oca(n):

  if n == 63:
    return 0

  dado1 = lanzar_dado()
  dado2 = lanzar_dado()

  n = mover(n, dado1, dado2)

  return 1 + turnos_jugados_oca(n)

print(turnos_jugados_oca(0))