'''
Auxiliar 12
    -> Polinomios
'''

class Polinomio():
    def __init__(self,L_coef):
        assert type(L_coef) == list
        assert all((type(coef)==int or type(coef)==float) for coef in L_coef)
        coef = L_coef.copy()
        end = len(coef) - 1
        while end>=0:
            if coef[end]==0:
                end -= 1
            else:
                break
        if end == -1: end+=1
        coef = coef[0:end+1]
        self.__coef = coef
        self.__n = len(coef)

    def __str__(self):
        def potencia_x(k):
            if k == 0:
                return ''
            elif k == 1:
                return 'x'
            else:
                return 'x^'+str(k)
        string = ''
        for i in range(self.__n):
            if self.__coef[i] != 0:
                string += str(self.__coef[i]) + potencia_x(i) + ' + '
        return string[0:-2]

    def __eq__(self,other):
        return self.__coef == other.__coef

    def __ne__(self,other):
        return self.__coef != other.__coef

    def __add__(self,other):
        n1,n2 = self.__n, other.__n
        coef1, coef2 = self.__coef.copy(), other.__coef.copy()
        max_n = max(n1,n2)
        coef1.extend([0]* (max_n-n1))
        coef2.extend([0] * (max_n-n2))
        assert len(coef1) == len(coef2)
        N = len(coef1)
        L_coef = []
        for i in range(N):
            L_coef.append(coef1[i] + coef2[i])
        return Polinomio(L_coef)

    def gr(self):
        return self.__n - 1

    def __mul__(self, other):
        if type(other) == Polinomio:
            gr1, gr2 = self.gr(), other.gr()
            coef1, coef2 = self.__coef.copy(), other.__coef.copy()
            gr = gr1+gr2
            L_coef = [0]*(gr+1)
            for i in range(len(coef1)):
                for j in range(len(coef2)):
                    L_coef[i+j] += coef1[i]*coef2[j]
            return Polinomio(L_coef)
        elif type(other) in [int, float]:
            L_coef = [coef * other for coef in self.__coef]
            return Polinomio(L_coef)
        else:
            assert False

    def __sub__(self, other):
        return self + (other*-1)

    def __pow__(self, power):
        assert type(power) == int and power>=0
        if power == 0:
            return Polinomio([1])
        else:
            return self * self**(power-1)


# testing
p1 = Polinomio([1,2,3,4])
p2 = Polinomio([0,0,1,0,0,1])
p3 = Polinomio([0])
p4 = Polinomio([1])
p5 = Polinomio([1,0,0,0,1,1,1,0,0,0,0,0,0,0])
print(p1)
print(p2)
print(p4)
print(p4*p1)
print(p1+p2)
print(p1*p2)
print(p1*5)
print(p2**2)
print(p1)
print(p5)
print(p1)
print(p2)
print(p2*p1)