'''
Auxiliar 12
'''

class Matriz():
    def __init__(self,valores):
        assert len(valores) > 0
        tamaño_fila = len(valores[0])
        for fila in valores:
            assert len(fila) == tamaño_fila
        self.M = valores.copy()
        self.n_filas = len(valores)
        self.n_col = len(valores[0])

    def __str__(self):
        string = ''
        for fila in self.M:
            string += str(fila)
            string += '\n'
        return string

    def __eq__(self, other):
        n, m = self.n_filas, self.n_col
        n2, m2 = other.n_filas, other.n_col
        if (n, m) != (n2, m2):
            return False
        for i in range(n):
            for j in range(m):
                if self.M[i][j] != other.M[i][j]:
                    return False
        return True

    def __add__(self, other):
        # if type(other) == Matriz:
        n1, m1 =  self.n_filas, self.n_col
        n2, m2 = other.n_filas,other.n_col
        assert (n1, m1) == (n2, m2)
        valores = []
        for i in range(n1):
            fila = []
            for j in range(m1):
                fila.append(self.M[i][j] + other.M[i][j])
            valores.append(fila)
        return Matriz(valores)

    def __mul__(self, other):
        if type(other) == Matriz:
            n1, m1 = self.n_filas, self.n_col
            n2, m2 = other.n_filas, other.n_col
            assert m1 == n2
            n, r, m = n1, m1, m2
            A, B = self.M, other.M
            valores = []
            for i in range(n):
                fila = []
                for j in range(m):
                    suma = 0
                    for k in range(r):
                        suma += A[i][k]*B[k][j]
                    fila.append(suma)
                valores.append(fila)
            return Matriz(valores)

        elif type(other) in [int,float]:
            n, m = self.n_filas, self.n_col
            valores = []
            for i in range(n):
                fila = []
                for j in range(m):
                    fila.append(self.M[i][j]*other)
                valores.append(fila)
            return Matriz(valores)
        else:
            assert False

    def __ne__(self,other):
        return not self == other

    def __sub__(self, other):
        return self + (other*-1)

    def __pow__(self,power):
        assert self.n_filas == self.n_col
        assert type(power)==int and power>=0
        n = self.n_filas
        if power==0:
            identidad = []
            for i in range(n):
                fila = []
                for j in range(n):
                    if i==j:
                        num = 1
                    else:
                        num = 0
                    fila.append(num)
                identidad.append(fila)
            return Matriz(identidad)
        return self * self**(power-1)



val = [[1,2,3],
       [4,5,6],
       [7,8,9]]

val1 = [[1,0,0],
        [0,1,0],
        [0,0,1]]

val2 = [[1,2,3],
        [3,2,1]]

val3 = [[1,2],
        [2,3],
        [5,6]]

val4 = [[1,2,3],
        [1,2]]

m1 = Matriz(val)
m2 = Matriz(val2)
m3 = Matriz(val3)
I = Matriz(val1)

# print(m1)
# print()
# print(m2)
# print()
# print(m3)
# print()
print(m1+m1)
print(m1 == I)
print()
print(m1*m1)
print()
print(m1*I)
print()
print(m1*1.5)
print()
print(m1!=I)
print()
print(m1-I)
print('hola')
print(m1**3 == m1*m1*m1)
# print(type(m1) == Matriz)