#%% LIBRERIAS

from pyevolve import G1DList
from pyevolve import Initializators
from pyevolve import Crossovers
from pyevolve import Mutators
from pyevolve import Selectors
from pyevolve import GSimpleGA

#%% OPCIONES

# swords  = [(100,10),(75,10),(10,10)]
# shields = [(100,10),(75,10),(10,10)]
# helmets = [(100,10),(75,10),(10,10)]
# armor1  = [(100,10),(75,10),(10,10)]
# armor2  = [(100,10),(75,10),(10,10)]
# rings   = [(100,10),(75,10),(10,10)]

# swords  = [(100,45),(75,30),(0,50)]
# shields = [(20,20),(25,22),(0,50)]
# helmets = [(5,20),(1,15),(0,50)]
# armor1  = [(90,500),(25,20),(0,50)]
# armor2  = [(80,200),(15,10),(0,50)]
# rings   = [(1.1,25),(1.5,50),(0,50)]

swords  = [(100,45),(75,30),(0,50),(120,40),(666,200),(60,2)]
shields = [(20,20),(25,22),(10,15),(0,5),(11,8),(3,10)]
helmets = [(5,20),(1,15),(2,50),(10,30),(2,12),(8,25)]
armor1  = [(90,500),(50,100),(33,50),(25,25),(100,300),(12,10)]
armor2  = [(80,200),(15,10),(18,40),(40,100),(22,22),(6,50)]
rings   = [(1.1,25),(1.5,50),(0,50),(5,500),(1.33,30),(0.5,-100)]

N_MAX = len(swords)
LIM_PESO = 600

# definir función objetivo
def our_function(a,b,c,d,e,f):
    atk = swords[a][0] + shields[b][0] +helmets[c][0] + armor1[d][0] + armor2[e][0]
    atk = atk*rings[f][0]
    pes = swords[a][1] + shields[b][1] +helmets[c][1] + armor1[d][1] + armor2[e][1] + rings[f][1]
    if pes > LIM_PESO:
        atk = 0
    return atk

genome = G1DList.G1DList(size = 6)

genome.setParams(rangemin = 0 , rangemax = N_MAX-1)

def eval_fitness(chromosome):
    a, b, c, d, e, f = chromosome
    score = our_function(a,b,c,d,e,f)
    return score

genome.evaluator.set(eval_fitness)

genome.initializator.set(Initializators.G1DListInitializatorInteger)

genome.crossover.set(Crossovers.G1DListCrossoverUniform)

genome.mutator.set(Mutators.G1DListMutatorIntegerRange)


#%%
POP_NUM = 20


PROB_CROSS = 0.5
PROB_MUT = 0.1


GEN_ITER = 200

#%%

GA_RUN = GSimpleGA.GSimpleGA(genome)
GA_RUN.setGenerations(GEN_ITER)

GA_RUN.setPopulationSize(POP_NUM)

GA_RUN.setCrossoverRate(PROB_CROSS)
GA_RUN.setMutationRate(PROB_MUT)

GA_RUN.selector.set(Selectors.GTournamentSelector)

GA_RUN.evolve()


bestIndividual = GA_RUN.bestIndividual()

BEST_FITNESS = bestIndividual.getFitnessScore()
BEST_SCORE = bestIndividual.getRawScore()
BEST_GENOME = bestIndividual.getInternalList()

# display resultados
print('Generation: %i' %(GEN_ITER))
print('     score: %f' %(BEST_SCORE))
print('     fitness: %f' %(BEST_FITNESS)+"\n")

a,b,c,d,e,f =bestIndividual

WWW = swords[a][1] + shields[b][1] +helmets[c][1] + armor1[d][1] + armor2[e][1] + rings[f][1]
ATK = our_function(a,b,c,d,e,f)
print('Best Weight: '+str(WWW))
print('Best ATK: '+str(ATK))

print("Posición en la lista:\n")
print(str(a))
print(str(b))
print(str(c))
print(str(d))
print(str(e))
print(str(f))