# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 13:53:58 2020

@author: viviana
"""


import numpy as np
import pandas as pd
import seaborn as sns
from sklearn.feature_selection import VarianceThreshold
from sklearn.preprocessing import MinMaxScaler
import matplotlib.pyplot as plt
from sklearn.decomposition import PCA
from sklearn.cluster import KMeans
from sklearn.cluster import MeanShift
from sklearn.cluster import DBSCAN
from sklearn import mixture
from sklearn.cluster import AgglomerativeClustering
from mpl_toolkits.mplot3d import Axes3D
from itertools import cycle
from sklearn import metrics

data = pd.read_excel('datos_aceite.xlsx')
print(data.columns)

#remover variables con alta correlación
corr = data.corr()
ax=sns.heatmap(corr)
plt.show()

print(corr.unstack().sort_values(ascending=False).head(30))

columnas = ['Fierro', 'Cromo', 'Aluminio', 'Cobre', 'Plomo', 'Nickel',
       'Estano', 'Vanadio', 'Cadmio', 'Manganeso', 'Sodio',
       'Potasio', 'Silicio', 'Zinc', 'Bario', 'Boro', 'Calcio',
       'Magnesio', 'Fosforo', 'v 40', 'Contenido agua', 'Partículas > 4um',
       'Partículas > 14um']

Xs = data[columnas]
corr = Xs.corr()
ax=sns.heatmap(corr)
plt.show()

print(corr.unstack().sort_values(ascending=False).head(30))

#normalizar max min
scaler = MinMaxScaler()
scaler.fit(Xs)
Xs=scaler.transform(Xs)
Xs.var()

#filtrar datos con baja varianza
sel = VarianceThreshold(0.01)
Xf=sel.fit_transform(Xs)

#Método de reducción
pca = PCA(n_components=10)
nombre_red='PCA'
Xt = pca.fit_transform(Xf)
varianza=pca.explained_variance_ratio_.cumsum()

#Metodo de agrupamiento
# Model=KMeans(n_clusters=3)
# nombre_mod='Kmeans'

# Model=MeanShift(bandwidth=0.7)
# nombre_mod='Mean Shift'

# Model=DBSCAN(eps=1.6, min_samples=5)
# nombre_mod='DBSCAN'

# Model=mixture.GaussianMixture(n_components=2)
# nombre_mod='Gaussian Mixture'

Model=AgglomerativeClustering(n_clusters=3)
nombre_mod='HAC'

Yp=Model.fit_predict(Xt)
silueta=metrics.silhouette_score(Xt,Yp)
calinski=metrics.calinski_harabasz_score(Xt,Yp)

print('Metodo: ', nombre_mod, ', Silueta: ', '{:.2f}'.format(silueta))
print('Metodo: ', nombre_mod, ', Calinski: ', '{:.2f}'.format(calinski))

labels_unique = np.unique(Yp)
n_clusters_ = len(labels_unique)

fig = plt.figure(figsize=(9,6))
ax = fig.add_subplot(111, projection='3d')
colors = cycle('bgrcmykbgrcmykbgrcmykbgrcmyk')
for k, col in zip(range(n_clusters_), colors):
    my_members = Yp == k
    ax.scatter(Xt[my_members, 0], Xt[my_members, 1], Xt[my_members, 2], col + '.')
    ax.set_xlim(-0.25,1.5)
    ax.set_ylim(-0.8,2.5)
    ax.set_zlim(-0.4,0.6)
    
plt.title('N° de grupos:' + str(n_clusters_) + ', Metodo de agrupamiento:' + nombre_mod)
plt.show()
