# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 13:49:49 2020

@author: viviana
"""

import numpy as np
import matplotlib.pyplot as plt
from sklearn.cluster import KMeans
from sklearn.cluster import MeanShift
from sklearn.cluster import DBSCAN
from sklearn import mixture
from sklearn.cluster import AgglomerativeClustering
from mpl_toolkits.mplot3d import Axes3D
from itertools import cycle

Xt=np.load('Xtodos.npy')
Yt=np.load('Label.npy')[:,0]

#Metodo de agrupamiento

# Model=KMeans(n_clusters=9)
# nombre_mod='Kmeans'

# Model=MeanShift(bandwidth=0.02)
# nombre_mod='Mean Shift'

# Model=DBSCAN(eps=0.02, min_samples=5)
# nombre_mod='DBSCAN'

# Model=mixture.GaussianMixture(n_components=9)
# nombre_mod='Gaussian Mixture'

Model=AgglomerativeClustering(n_clusters=9)
nombre_mod='HAC'

Yp=Model.fit_predict(Xt)
labels_unique = np.unique(Yp)
n_clusters_ = len(labels_unique)

fig = plt.figure(figsize=(9,6))
ax = fig.add_subplot(111, projection='3d')
colors = cycle('bgrcmykbgrcmykbgrcmykbgrcmyk')
for k, col in zip(range(n_clusters_), colors):
    my_members = Yp == k
    ax.scatter(Xt[my_members, 0], Xt[my_members, 1], Xt[my_members, 2], col + '.')
plt.title('N° de grupos:' + str(n_clusters_) + ', Metodo de agrupamiento:' + nombre_mod)
plt.show()

fig = plt.figure(figsize=(9,6))
ax = fig.add_subplot(111, projection='3d')
colors = cycle('bgrcmykbgrcmykbgrcmykbgrcmyk')
for k, col in zip(range(9), colors):
    my_members = Yt == k
    ax.scatter(Xt[my_members, 0], Xt[my_members, 1], Xt[my_members, 2], col + '.')
plt.title('Real')
plt.show()
