# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 13:48:10 2020

@author: viviana
"""


import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.svm import SVC
from sklearn.model_selection import GridSearchCV
from sklearn.model_selection import RandomizedSearchCV
from scipy import stats


Xt=np.load('Xtodos.npy')
Xt=Xt[:,0:5]
Yt=np.load('Label.npy')
Yt=Yt[:,0]

X_train, X_test, y_train, y_test = train_test_split(Xt, Yt, test_size=0.20)

Model= SVC(kernel='rbf')

#Grid Search
param_grid = {'C': [1, 10, 100, 500, 1000, 10000], 'gamma': [1, 2, 4, 8, 16, 32, 64, 128, 256]}

grid_search = GridSearchCV(Model, param_grid=param_grid, cv=5)
grid_search.fit(X_train, y_train)
Resultados_GridSearch=grid_search.cv_results_;

indice1 = np.argmax(Resultados_GridSearch['mean_test_score'])
print('Grid Search best test score= '+str(round(max(Resultados_GridSearch['mean_test_score'])*100,2))+ ', parametros: '+str(Resultados_GridSearch['params'][indice1]))

#Random Search
param_distr = {'C': stats.randint(1, 10000), 'gamma': stats.uniform(1, 256)}

random_search = RandomizedSearchCV(Model, param_distributions=param_distr,n_iter=50, cv=5)
random_search.fit(X_train, y_train)

Resultados_RandomSearch=random_search.cv_results_;

indice2 = np.argmax(Resultados_RandomSearch['mean_test_score'])
print('Random Search best test score= '+str(round(max(Resultados_RandomSearch['mean_test_score'])*100,2))+ ', parametros: '+str(Resultados_RandomSearch['params'][indice2]))