# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 13:33:08 2020

@author: viviana
"""

import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.neighbors import KNeighborsClassifier
from sklearn.tree import DecisionTreeClassifier
from sklearn.ensemble import RandomForestClassifier
from sklearn.svm import SVC
from sklearn.model_selection import cross_validate
from sklearn.ensemble import VotingClassifier


Xt=np.load('Xtodos.npy')
Xt=Xt[:,0:5]
Yt=np.load('Label.npy')
Yt=Yt[:,0]

X_train, X_test, y_train, y_test = train_test_split(Xt, Yt, test_size=0.20)

Model1 = KNeighborsClassifier(n_neighbors=10)
Model2=RandomForestClassifier(n_estimators=50) 
Model3 = SVC(kernel='sigmoid',C=2) #‘linear’, ‘poly’, ‘rbf’, ‘sigmoid’

Model= VotingClassifier(estimators=[('Knearest', Model1), ('RandomForest', Model2), ('svc', Model3)],voting='hard')

Model1 = Model1.fit(X_train, y_train)
Model2 = Model2.fit(X_train, y_train)
Model3 = Model3.fit(X_train, y_train)

scores1 = cross_validate(Model1, X_train, y_train,cv=5)
print("model1= ", scores1['test_score'], "promedio= ",np.mean(scores1['test_score']))

scores2 = cross_validate(Model2, X_train, y_train,cv=5)
print("model2= ", scores2['test_score'], "promedio= ",np.mean(scores2['test_score']))

scores3 = cross_validate(Model3, X_train, y_train,cv=5)
print("model3= ", scores3['test_score'], "promedio= ",np.mean(scores3['test_score']))

scores = cross_validate(Model, X_train, y_train,cv=5)
print("Combinados= ", scores['test_score'], "promedio= ",np.mean(scores['test_score']))