# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 13:30:46 2020

@author: viviana
"""

import numpy as np
import matplotlib.pyplot as plt
from sklearn.model_selection import train_test_split
from sklearn.tree import DecisionTreeClassifier
from sklearn.ensemble import RandomForestClassifier
from sklearn.svm import SVC
from sklearn.neighbors import KNeighborsClassifier

from sklearn.metrics import classification_report
from sklearn.metrics import plot_confusion_matrix

Xt=np.load('Xtodos.npy')
Yt=np.load('Label.npy')

X_train, X_test, y_train, y_test = train_test_split(Xt, Yt, test_size=0.20)

# Model = KNeighborsClassifier(n_neighbors=10)
# Model=DecisionTreeClassifier(criterion='entropy') #el criterio puede ser gini o entropy
# Model=RandomForestClassifier(n_estimators=10) 
Model = SVC(kernel='sigmoid',C=2) #‘linear’, ‘poly’, ‘rbf’, ‘sigmoid’
Model.fit(X_train, y_train) 
Yp=Model.predict(X_test)

disp=plot_confusion_matrix(Model, X_test, y_test)
disp.ax_.set_title('Titulo')
plt.show()

target_names = ['Healthy', 'Missing', 'Crack', 'Spall', 'chip5a', 'chip4a', 'chip3a', 'chip2a', 'chip1a']
print(classification_report(y_test, Yp, target_names=target_names))

