# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 13:23:53 2020

@author: viviana
"""

#importar librerias
import numpy as np
import scipy.io as sio
import matplotlib.pyplot as plt
from sklearn.covariance import EllipticEnvelope
from sklearn.ensemble import IsolationForest
from sklearn.neighbors import LocalOutlierFactor
from sklearn import svm
from sklearn.metrics import precision_score, accuracy_score, recall_score, f1_score, confusion_matrix

#Leer datos
Xt=np.load('Xt.npy')
Datos=Xt

Label=sio.loadmat('labelA.mat') #Healthy
Yt=Label['labelA']


outlier_frac=0.1 #fracción de valores anomalos, valor por defecto es 0.1
# Model= EllipticEnvelope(contamination=outlier_frac)
# Model=IsolationForest(n_estimators=100, max_samples='auto', contamination=outlier_frac)
# Model = LocalOutlierFactor(n_neighbors=20, contamination=outlier_frac)
Model = svm.OneClassSVM(nu=0.4, kernel="rbf", gamma='auto')
Yp=Model.fit_predict(Datos)

Yp=np.where(Yp==1, 0, Yp)
Yp=np.where(Yp==-1, 1, Yp)

Xp0=Datos[np.where(Yp == 0)[0],:]      
Xp1=Datos[np.where(Yp == 1)[0],:]
         
Xt0=Datos[np.where(Yt == 0)[0],:]      
Xt1=Datos[np.where(Yt == 1)[0],:]

       
plt.scatter(Xp0[:, 0], Xp0[:, 1])
plt.scatter(Xp1[:, 0], Xp1[:, 1])
plt.xlabel('Parámetro 1', fontsize=14)
plt.ylabel('Parámetro 2', fontsize=14)
plt.legend(('Sin daño','Con Daño'), fontsize=14)
plt.title('OC-SVM', fontsize=14)
plt.show()

plt.scatter(Xt0[:, 0], Xt0[:, 1])
plt.scatter(Xt1[:, 0], Xt1[:, 1])
plt.xlabel('Parámetro 1', fontsize=14)
plt.ylabel('Parámetro 2', fontsize=14)
plt.legend(('Sin daño','Con Daño'), fontsize=14)
plt.title('Real', fontsize=14)
plt.show()

Exactitud=accuracy_score(Yt, Yp)
Presicion=precision_score(Yt, Yp)
Sensibilidad=recall_score(Yt, Yp)
F1score=f1_score(Yt, Yp)

print("Exactitud= ", '{:.2f}'.format(Exactitud))
print("Presicion= ", '{:.2f}'.format(Presicion))
print("Sensibilidad= ", '{:.2f}'.format(Sensibilidad))
print("F1 score= ", '{:.2f}'.format(F1score))

