# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 13:19:32 2020

@author: viviana
"""

#importar librerías
import scipy.io as sio
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
import numpy as np
from sklearn.decomposition import PCA
from scipy.fftpack import fft


#Leer datos
Datos=sio.loadmat('DatosA.mat') #Healthy
Datos=Datos['DatosA']

#vector de tiempo
Fs=1000#sampling rate
dt=1/Fs #paso de tiempo
Ns=114 #numero de segmentos
L=3600 #datos por segmento
    
P=np.zeros((Ns,int(L/2)))


for i in range(0,Ns):
    x=Datos[:,i]
    F = fft(x)[0:int(L/2)]/(L/2)
    P[i,:]=abs(F).transpose()

    
# PCA
pca = PCA(n_components=34)
pca.fit(P)
varianza=pca.explained_variance_ratio_.cumsum()

plt.plot(varianza)
plt.xlabel('Numero de componentes', fontsize=14)
plt.ylabel('Varianza acumulada', fontsize=14)

Xt=pca.transform(P)

fig = plt.figure(figsize=(9,6))
ax = fig.add_subplot(111, projection='3d')
ax.scatter(Xt[:, 0], Xt[:, 1],Xt[:, 2])
ax.set_xlabel('Parámetro 1', fontsize=14)
ax.set_ylabel('Parámetro 2', fontsize=14)
ax.set_zlabel('Parámetro 3', fontsize=14)
plt.show()

np.save('Xt',Xt)
