# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 12:13:40 2020

@author: viviana
"""
#importar librerias
import numpy as np
import matplotlib.pyplot as plt
from sklearn import preprocessing
from sklearn.decomposition import PCA, KernelPCA
from sklearn.discriminant_analysis import LinearDiscriminantAnalysis
from sklearn.manifold import MDS
from sklearn.manifold import Isomap
from mpl_toolkits.mplot3d import Axes3D

Pn=np.load('Pn.npy') 
Po=np.load('Po.npy') 
Pi=np.load('Pi.npy') 
En=np.load('En.npy') 
Eo=np.load('Eo.npy') 
Ei=np.load('Ei.npy') 

P0=np.concatenate((Pn,En),axis=1)
P1=np.concatenate((Po,Eo),axis=1)
P2=np.concatenate((Pi,Ei),axis=1)

Nt=len(Pi) #numero de datos 

X=np.concatenate((P0,P1,P2),axis=0) 

# estandarizar los datos
scaler = preprocessing.StandardScaler().fit(X)
Xs=scaler.transform(X) 

# #PCA
# pca = PCA(n_components=3)
# Xt = pca.fit_transform(Xs)

#Kernel PCA
kpca = KernelPCA(n_components=3, kernel="cosine") #linear, rbf, poly, sigmmoid
Xt = kpca.fit_transform(Xs)

# #MDS
# embedding = MDS(n_components=3)
# Xt =embedding.fit_transform(Xs)

# #ISOMAP
# embedding = Isomap(n_components=3)
# Xt =embedding.fit_transform(Xs)

fig = plt.figure(figsize=(9,6))
ax = fig.add_subplot(111, projection='3d')
ax.scatter(Xt[1:Nt, 0], Xt[1:Nt, 1],Xt[1:Nt, 2])
ax.scatter(Xt[Nt+1:2*Nt, 0], Xt[Nt+1:2*Nt, 1],Xt[Nt+1:2*Nt, 2])
ax.scatter(Xt[2*Nt+1:3*Nt, 0], Xt[2*Nt+1:3*Nt, 1],Xt[2*Nt+1:3*Nt, 2])
plt.xlabel('Parámetro 1', fontsize=14)
plt.ylabel('Parámetro 2', fontsize=14)
plt.ylabel('Parámetro 3', fontsize=14)
plt.title('Kernel PCA', fontsize=14)

#LDA
#etiquetas
y1=np.ones(len(P0));
y2=2*np.ones(len(P1));
y3=3*np.ones(len(P2));
Y=np.concatenate((y1,y2,y3),axis=0)
lda = LinearDiscriminantAnalysis(n_components=2) #n_components < n_classes - 1
Xt = lda.fit_transform(Xs,Y)

plt.figure()
plt.scatter(Xt[1:Nt, 0], Xt[1:Nt, 1])
plt.scatter(Xt[Nt+1:2*Nt, 0], Xt[Nt+1:2*Nt, 1])
plt.scatter(Xt[2*Nt+1:3*Nt, 0], Xt[2*Nt+1:3*Nt, 1])
plt.xlabel('Parámetro 1', fontsize=14)
plt.ylabel('Parámetro 2', fontsize=14)
plt.title('LDA', fontsize=14)
