# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 12:12:10 2020

@author: viviana
"""

#importar librerias
import scipy.io as sio
from scipy import signal
import matplotlib.pyplot as plt
import numpy as np

#Leer datos
Datos0=sio.loadmat('normal.mat')
Datos1=sio.loadmat('outer.mat')
Datos2=sio.loadmat('inner.mat')
Normal=Datos0['normal']
Outer=Datos1['outer']
Inner=Datos2['inner']

#Datos
Fs=48828 #sampling rate
dt=1/Fs
Nd=20000

scales=np.arange(1, 50)

x1=Normal[1:Nd,0]
x2=Outer[1:Nd,0]
x3=Inner[1:Nd,0]
t = np.linspace(0, (Nd-1)*dt, Nd)  # Intervalo de tiempo en segundos

cwt1 = signal.cwt(x1, signal.ricker,scales)
cwt2 = signal.cwt(x2, signal.ricker,scales)
cwt3 = signal.cwt(x3, signal.ricker,scales)

plt.pcolormesh(t,scales,cwt1,cmap='pink')
plt.ylabel('Escala', fontsize=14)
plt.xlabel('Tiempo [sec]', fontsize=14)
plt.title('Normal', fontsize=14)
plt.show()

plt.pcolormesh(t,scales,cwt2,cmap='pink')
plt.ylabel('Escala', fontsize=14)
plt.xlabel('Tiempo [sec]', fontsize=14)
plt.title('Pista Externa', fontsize=14)
plt.show()

plt.pcolormesh(t,scales,cwt3,cmap='pink')
plt.ylabel('Escala', fontsize=14)
plt.xlabel('Tiempo [sec]', fontsize=14)
plt.title('Pista interna', fontsize=14)
plt.show()
