# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 12:11:03 2020

@author: viviana
"""
#importar librerías
import scipy.io as sio
from scipy import signal
import matplotlib.pyplot as plt


#Leer datos
Datos0=sio.loadmat('normal.mat')
Datos1=sio.loadmat('outer.mat')
Datos2=sio.loadmat('inner.mat')
Normal=Datos0['normal']
Outer=Datos1['outer']
Inner=Datos2['inner']

#Datos
Fs=48828 #sampling rate
Nd=100000

x1=Normal[1:Nd,0]
f, t, S1 = signal.spectrogram(x1,Fs,window='hann',nperseg=500,noverlap=0)

x2=Outer[1:Nd,0]
f, t, S2 = signal.spectrogram(x2,Fs,window='hann',nperseg=500,noverlap=0)

x3=Inner[1:Nd,0]
f, t, S3 = signal.spectrogram(x3,Fs,window='hann',nperseg=500,noverlap=0)

plt.pcolormesh(t, f, S1,cmap='pink')
plt.ylabel('Frecuencia[Hz]', fontsize=14)
plt.xlabel('Tiempo [sec]', fontsize=14)
plt.title('Normal', fontsize=14)
plt.show()

plt.pcolormesh(t, f, S2,cmap='pink')
plt.ylabel('Frecuencia[Hz]', fontsize=14)
plt.xlabel('Tiempo [sec]', fontsize=14)
plt.title('Pista Externa', fontsize=14)
plt.show()

plt.pcolormesh(t, f, S3,cmap='pink')
plt.ylabel('Frecuencia[Hz]', fontsize=14)
plt.xlabel('Tiempo [sec]', fontsize=14)
plt.title('Pista Interna', fontsize=14)
plt.show()


