# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 12:10:05 2020

@author: viviana
"""

from scipy import signal
import matplotlib.pyplot as plt
import numpy as np
from numpy import pi

fs = 10e3 #frecuencia de muestreo Hz
N = 100000 #numero de datos
dt = 1/fs # Espaciado temporal
t = np.linspace(0, (N-1)*dt, N)  # Intervalo de tiempo en segundos
mod = 500*np.cos(2*np.pi*0.25*t)
carrier = 5 * np.sin(2*np.pi*3e3*t + mod)
mu, sigma = 0, 10
noise = np.random.normal(mu,sigma,N)
x = carrier + noise

plt.plot(t, x)
plt.xlabel('Tiempo (s)', fontsize=14)
plt.ylabel('$x(t)$', fontsize=14)
plt.xlim(0,0.01)
plt.show()

f, t, Sxx = signal.spectrogram(x, fs,window='hann',nperseg=500,noverlap=250)
plt.figure()
plt.pcolormesh(t, f, Sxx,cmap='Blues')
plt.ylabel('Frecuencia[Hz]')
plt.xlabel('Tiempo [sec]')
plt.show()

