# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 12:08:55 2020

@author: viviana
"""

#importar librerias
import scipy.io as sio
import numpy as np
import matplotlib.pyplot as plt
import math
from scipy.fftpack import fft, fftfreq
from numpy import mean, sqrt, square

#Leer datos
Datos0=sio.loadmat('normal.mat')
Datos1=sio.loadmat('outer.mat')
Datos2=sio.loadmat('inner.mat')
Normal=Datos0['normal']
Outer=Datos1['outer']
Inner=Datos2['inner']

#Datos
Fs=48828 #sampling rate
dt=1/Fs #paso de tiempo
N=len(Normal) #numero de datos

#Dividir por segmentos
L=5000 #largo de los segmentos
l=1000 #overlap
Nt=math.floor((N-l)/(L-l)) #total de segmentos
nb=8 #numero de bandas

En=np.zeros((Nt,nb))
Eo=np.zeros((Nt,nb))
Ei=np.zeros((Nt,nb))

for i in range(1,Nt+1):
    inicio=(i-1)*L-(i-1)*l+1
    fin=i*L-(i-1)*l

    Fn = fft(Normal[inicio:fin,0])[0:int(L/2)]/(L/2)
    Fo = fft(Outer[inicio:fin,0])[0:int(L/2)]/(L/2)
    Fi = fft(Inner[inicio:fin,0])[0:int(L/2)]/(L/2)
    frq = fftfreq(L,dt)[0:int(L/2)] 
    
    Lb=int(L/2/nb)
    for k in range(1,nb+1):
        inicio=Lb*(k-1)+1
        fin=k*Lb
        En[i-1][k-1]=mean(abs(Fn[inicio:fin]))
        Eo[i-1][k-1]=mean(abs(Fo[inicio:fin]))
        Ei[i-1][k-1]=mean(abs(Fi[inicio:fin]))

#guardar parámetros
np.save('En.npy', En) 
np.save('Eo.npy', Eo) 
np.save('Ei.npy', Ei) 

f, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2, 2, sharex='col',figsize=(9,6))

ax1.plot(En[:,0])
ax1.plot(Eo[:,0])
ax1.plot(Ei[:,0])
ax1.legend(['Normal','Pista externa','Pista interna'])
ax1.set_title('Banda 1', fontsize=14)

ax2.plot(En[:,1])
ax2.plot(Eo[:,1])
ax2.plot(Ei[:,1])
ax2.legend(['Normal','Pista externa','Pista interna'])
ax2.set_title('Banda 2', fontsize=14)

ax3.plot(En[:,2])
ax3.plot(Eo[:,2])
ax3.plot(Ei[:,2])
ax3.legend(['Normal','Pista externa','Pista interna'])
ax3.set_title('Banda 3', fontsize=14)

ax4.plot(En[:,3])
ax4.plot(Eo[:,3])
ax4.plot(Ei[:,3])
ax4.legend(['Normal','Pista externa','Pista interna'])
ax4.set_title('Banda 4', fontsize=14)

f, ((ax5, ax6), (ax7, ax8)) = plt.subplots(2, 2, sharex='col',figsize=(9,6))
ax5.plot(En[:,4])
ax5.plot(Eo[:,4])
ax5.plot(Ei[:,4])
ax5.legend(['Normal','Pista externa','Pista interna'])
ax5.set_title('Banda 5', fontsize=14)

ax6.plot(En[:,5])
ax6.plot(Eo[:,5])
ax6.plot(Ei[:,5])
ax6.legend(['Normal','Pista externa','Pista interna'])
ax6.set_title('Banda 6', fontsize=14)

ax7.plot(En[:,6])
ax7.plot(Eo[:,6])
ax7.plot(Ei[:,6])
ax7.legend(['Normal','Pista externa','Pista interna'])
ax7.set_title('Banda 7', fontsize=14)

ax8.plot(En[:,7])
ax8.plot(Eo[:,7])
ax8.plot(Ei[:,7])
ax8.legend(['Normal','Pista externa','Pista interna'])
ax8.set_title('Banda 8', fontsize=14)

