# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 12:08:31 2020

@author: viviana
"""

from scipy.fftpack import fft, fftfreq
import matplotlib.pyplot as plt
import numpy as np
from numpy import pi

N = 2000  # Número de datos
fs= 1000  # Frecuencia de muestreo/adquisición
dt = 1/fs # Espaciado, 16 puntos por período
t = np.linspace(0, (N-1)*dt, N)  # Intervalo de tiempo en segundos
y = np.sin(2*pi *123*t) - 0.8*np.sin(2*pi*60*t)  # Señal

#Transformada de Fourier
Y = fft(y)[0:int(N/2)]/(N/2)
frq = fftfreq(N,dt)[0:int(N/2)] #vector de frecuencias

fig,ax = plt.subplots(1)
ax.plot(t, y)
plt.xlabel('Tiempo (s)', fontsize=14)
plt.ylabel('$y(t)$', fontsize=14)
plt.xlim(0,0.1)
plt.show()

fig,ax = plt.subplots(1)
plt.plot(frq,abs(Y))
plt.xlabel('Frecuencia (Hz)', fontsize=14)
plt.ylabel('$F(\omega)$', fontsize=14)
plt.show()

