# -*- coding: utf-8 -*-
"""
Created on Mon Nov  9 12:05:01 2020

@author: viviana
"""
#importar librerías
import scipy.io as sio
import numpy as np
import matplotlib.pyplot as plt
import math
from scipy.stats import kurtosis, skew
from numpy import mean, sqrt, square

#Leer datos
Datos0=sio.loadmat('normal.mat')
Datos1=sio.loadmat('outer.mat')
Datos2=sio.loadmat('inner.mat')
Normal=Datos0['normal']
Outer=Datos1['outer']
Inner=Datos2['inner']

#vector de tiempo
Fs=48828 #sampling rate
dt=1/Fs #paso de tiempo
N=len(Normal)
t=np.linspace(0,dt*(N-1),N)

plt.plot(t,Normal)
plt.xlabel('Tiempo (s)', fontsize=14)
plt.ylabel('Aceleración ' "$(m/s^2)$", fontsize=14)
plt.title('Normal', fontsize=14)
plt.xlim(0,0.01)
plt.ylim(-4,4)
plt.show()

plt.plot(t,Outer)
plt.xlabel('Tiempo (s)', fontsize=14)
plt.ylabel('Aceleración ' "$(m/s^2)$", fontsize=14)
plt.title('Daño pista externa', fontsize=14)
plt.xlim(0,0.01)
plt.ylim(-4,4)
plt.show()

plt.plot(t,Inner)
plt.xlabel('Tiempo (s)', fontsize=14)
plt.ylabel('Aceleración ' "$(m/s^2)$", fontsize=14)
plt.title('Daño pista interna', fontsize=14)
plt.xlim(0,0.01)
plt.ylim(-4,4)
plt.show()

#calcular parametros por tramos
L=5000 #largo de los segmentos
l=1000 #overlap
Nt=math.floor((N-l)/(L-l)) #total de tramos


#inicializar matrices con parametros
Pn=np.zeros((Nt,8))
Po=np.zeros((Nt,8))
Pi=np.zeros((Nt,8))

for i in range(1,Nt+1):
    inicio=(i-1)*L-(i-1)*l+1
    fin=i*L-(i-1)*l

    Pn[i-1,0]=sqrt(mean(square(Normal[inicio:fin]))) #RMS
    Pn[i-1,1]=np.amax(Normal[inicio:fin]) #Peak
    Pn[i-1,2]=np.amax(Normal[inicio:fin])-np.amin(Normal[inicio:fin]) #peak-peak
    Pn[i-1,3]=Pn[i-1,1]/Pn[i-1,0] #crest
    Pn[i-1,4]=np.mean(Normal[inicio:fin]) #Media
    Pn[i-1,5]=np.var(Normal[inicio:fin]) #var
    Pn[i-1,6]=skew(Normal[inicio:fin])[0] #asimetria
    Pn[i-1,7]=kurtosis(Normal[inicio:fin])[0] #curtosis
    
    Po[i-1,0]=sqrt(mean(square(Outer[inicio:fin]))) #RMS
    Po[i-1,1]=np.amax(Outer[inicio:fin]) #Peak
    Po[i-1,2]=np.amax(Outer[inicio:fin])-np.amin(Outer[inicio:fin]) #peak-peak
    Po[i-1,3]=Po[i-1,1]/Po[i-1,0] #crest
    Po[i-1,4]=np.mean(Outer[inicio:fin]) #Media
    Po[i-1,5]=np.var(Outer[inicio:fin]) #var
    Po[i-1,6]=skew(Outer[inicio:fin])[0] #asimetria
    Po[i-1,7]=kurtosis(Outer[inicio:fin])[0] #curtosis
    
    Pi[i-1,0]=sqrt(mean(square(Inner[inicio:fin]))) #RMS
    Pi[i-1,1]=np.amax(Inner[inicio:fin]) #Peak
    Pi[i-1,2]=np.amax(Inner[inicio:fin])-np.amin(Inner[inicio:fin]) #peak-peak
    Pi[i-1,3]=Pi[i-1,1]/Pi[i-1,0] #crest
    Pi[i-1,4]=np.mean(Inner[inicio:fin]) #Media
    Pi[i-1,5]=np.var(Inner[inicio:fin]) #var
    Pi[i-1,6]=skew(Inner[inicio:fin])[0] #asimetria
    Pi[i-1,7]=kurtosis(Inner[inicio:fin])[0] #curtosis

#guardar parámetros
np.save('Pn.npy', Pn) 
np.save('Po.npy', Po) 
np.save('Pi.npy', Pi) 

#graficar datos
f, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2, 2, sharex='col',figsize=(9,6))
ax1.plot(Pn[:,0])
ax1.plot(Po[:,0])
ax1.plot(Pi[:,0])
ax1.legend(['Normal','Pista externa','Pista interna'])
ax1.set_title('RMS', fontsize=14)

ax2.plot(Pn[:,1])
ax2.plot(Po[:,1])
ax2.plot(Pi[:,1])
ax2.legend(['Normal','Pista externa','Pista interna'])
ax2.set_title('Valor peak', fontsize=14)

ax3.plot(Pn[:,2])
ax3.plot(Po[:,2])
ax3.plot(Pi[:,2])
ax3.legend(['Normal','Pista externa','Pista interna'])
ax3.set(xlabel='Segmento')
ax3.set_title('Valor peak-peak', fontsize=14)

ax4.plot(Pn[:,3])
ax4.plot(Po[:,3])
ax4.plot(Pi[:,3])
ax4.legend(['Normal','Pista externa','Pista interna'])
ax4.set(xlabel='Segmento')
ax4.set_title('Factor de cresta', fontsize=14)

f, ((ax5, ax6), (ax7, ax8)) = plt.subplots(2, 2, sharex='col',figsize=(9,6))
ax5.plot(Pn[:,4])
ax5.plot(Po[:,4])
ax5.plot(Pi[:,4])
ax5.legend(['Normal','Pista externa','Pista interna'])
ax5.set_title('Media Aritmética', fontsize=14)

ax6.plot(Pn[:,5])
ax6.plot(Po[:,5])
ax6.plot(Pi[:,5])
ax6.legend(['Normal','Pista externa','Pista interna'])
ax6.set_title('Varianza', fontsize=14)

ax7.plot(Pn[:,6])
ax7.plot(Po[:,6])
ax7.plot(Pi[:,6])
ax7.legend(['Normal','Pista externa','Pista interna'])
ax7.set(xlabel='Segmento')
ax7.set_title('Asimetría', fontsize=14)

ax8.plot(Pn[:,7])
ax8.plot(Po[:,7])
ax8.plot(Pi[:,7])
ax8.legend(['Normal','Pista externa','Pista interna'])
ax8.set(xlabel='Segmento')
ax8.set_title('Curtosis', fontsize=14)

