package core;

import predicate.Predicate;

import java.util.ArrayList;
import java.util.List;

public class Library {
    private List<Item> items;

    public Library() {
        this.items = new ArrayList<>();
    }

    public void add(Item anItem) {
        this.items.add(anItem);
    }

    public int numberOfItems() {
        return items.size();
    }

    public Item search(Predicate p) {
        for(Item item : items){
            if(p.check(item))
                return item;
        }
        return null;
    }
}
