package tests;

import core.Book;
import core.Library;
import core.PSXGame;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import predicate.AndPredicate;
import predicate.NamePredicate;
import predicate.YearPredicate;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class LibraryTest {
    private Library library;
    private Book book1, book2, book3;
    private PSXGame game1;


    @BeforeEach
    public void setup (){
        library = new Library();
        book1 = new Book("Vasco", 1980);
        book2 = new Book("Agile Visualization", 2021);
        book3 = new Book("Agile Visualization", 2016);
        game1 = new PSXGame("Polytopia", 2018);
        library.add(book1);
        library.add(book2);
        library.add(game1);
    }

    @Test
    public void testBasic() {
        Assertions.assertEquals(3, library.numberOfItems());
        Assertions.assertEquals(0, new Library().numberOfItems());
    }

    @Test
    public void testSearch() {
        Assertions.assertEquals(game1, library.search(new NamePredicate("Polytopia")));
        Assertions.assertEquals(null, library.search(new NamePredicate("Polytopia2")));
        Assertions.assertEquals(book1, library.search(new NamePredicate("Vasco")));
    }

    @Test
    public void testSearchByYear() {
        Assertions.assertEquals(book1, library.search(new YearPredicate(1980)));
    }

    @Test
    public void testSearchByYearAndName() {
        Assertions.assertEquals(book2, library.search(new AndPredicate(
                new NamePredicate("Agile Visualization"),
                new YearPredicate(2021))));
    }

}
