package cachipun.test;

import cachipun.*;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class CachipunTest {
    //private Hand stone, paper, scissor;
    private Stone stone;
    private Paper paper;
    private Scissor scissor;

    @Test
    public void testStoneSize() {
        assertTrue(stone.stoneSize() > 10);
    }

    @BeforeEach
    public void setUp() {
        stone = new Stone();
        paper = new Paper();
        scissor = new Scissor();
    }

    @Test
    public void testPaper() {
        assertEquals(0, paper.playWith(paper));
        assertEquals(0, paper.playWith(new Paper()));
        assertEquals(1, paper.playWith(stone));
        assertEquals(-1, paper.playWith(scissor));
    }

    @Test
    public void testStone() {
        assertEquals(0, stone.playWith(stone));
        assertEquals(0, stone.playWith(new Stone()));
        assertEquals(1, stone.playWith(scissor));
        assertEquals(-1, stone.playWith(paper));
    }

    @Test
    public void testScissor() {
        assertEquals(0, scissor.playWith(scissor));
        assertEquals(0, scissor.playWith(new Scissor()));
        assertEquals(1, scissor.playWith(paper));
        assertEquals(-1, scissor.playWith(stone));
    }

}
