import estructura

# ABB
#              Valor
#   izq <= Valor   der > Valor
# ABB: valor(num) izq(ABB) der(ABB)

estructura.crear("ABB","valor izq der")

A1 = ABB(50, ABB(26, ABB(10, None, None),
                 ABB(45, None, None)),
         ABB(70, ABB(55, None, None),
             ABB(120, None, None)))
A2 = ABB(50, ABB(26, ABB(10, None, ABB(15,None, None)),
                 ABB(45, None, None)),
         ABB(70, ABB(55, None, None),
             ABB(120, None, None)))


# extraerMax: ABB -> num (o None)
# Recibe un ABB y retorna el mayor
# valor que este contiene
# Ejemplo: extraerMax(A1) -> 120
def extraerMax(Arbol):
    if Arbol == None:
        return None
    elif Arbol.der == None:
        return Arbol.valor
    else:
        return extraerMax(Arbol.der)
# Test
assert(extraerMax(A1) == 120)

# extraerMin: ABB -> num (o None)
# Recibe un ABB y retorna el menor
# valor que este contiene
# Ejemplo:  extraerMin(A1) -> 10
def extraerMin(Arbol):
    if Arbol == None:
        return None
    elif Arbol.izq == None:
        return Arbol.valor
    else:
        return extraerMin(Arbol.izq)
# Test
assert(extraerMin(A1) == 10)

# esABB: ABB -> bool
# Recibe un arbol he indica si es
# o no un árbol ABB
# Ejemplo:  esABB(A1) -> True
def esABB(Arbol):
    return (Arbol == None or
            (type(Arbol) == ABB and
             esABB(Arbol.izq) and esABB(Arbol.der))
            and (extraerMin(Arbol) <= Arbol.valor)
            and (extraerMax(Arbol) >= Arbol.valor))
# Test
assert esABB(A1)

# estaValor: ABB num -> bool
# Recibe un arbol y un valor
# dice si dicho valor esta en el árbol
# Ejemplo:  estaValor(A1,45) -> True
def estaValor(Arbol, valor):
    assert esABB(Arbol)
    assert type(valor)== int or type(valor)==float
    if Arbol == None:
        return False
    elif Arbol.valor == valor:
        return True
    else:
        if Arbol.valor < valor:
            return estaValor(Arbol.der, valor)
        else:
            return estaValor(Arbol.izq, valor)
# Test
assert estaValor(A1,45)


# insertarValor: ABB num -> ABB
# Recibe un ABB y un valor
# e inserta dicho valor en el ABB
# Ejemplo: insertarValor(A1, 15) -> A2
def insertarValor(Arbol, valor):
    assert esABB(Arbol)
    assert type(valor)== int or type(valor)==float
    if Arbol == None:
        return ABB(valor, None, None)
    elif valor <= Arbol.valor:
        return ABB(Arbol.valor, insertarValor(Arbol.izq, valor), Arbol.der)
    return ABB(Arbol.valor, Arbol.izq , insertarValor(Arbol.izq, valor))
# Test
assert insertarValor(A1, 15) == A2


