# -*- coding: utf-8 -*-
"""
Created on Wed Aug 21 13:33:24 2019
Libreria de funcionaes para realizar tiradas de ataque o defensa.

@author: Juampi
"""
import numpy

def rollAttack(dados, foco):
    '''
        Realiza una tirada de  ataque
        :param dados: cantidad de dados de rojos lanzados
        :param foco: si el atacante posee foco (1) o no (0)
        :returns: cantidad de hits, foco 1 o 0 si aún lo posee o no.
    '''
    resultados = []
    for roll in range(dados):
        resultados.append(rollRedDie())
    hits = resultados.count("hit")
    eyes = resultados.count("eye")
    #print(resultados)
    if foco == 1 and eyes > 0:
        return hits + eyes, 0
    elif foco == 1 and eyes == 0:
        return hits, 1
    else:
        return hits, 0
    
    
def rollDefense(dados, foco, hits):
    '''
        Realiza una tirada de defensa
        :param dados: cantidad de dados de verdes lanzados
        :param foco: si el defensos posee foco (1) o no (0)
        :param hits: la cantidad de hits que obtuvo el atacante
        :returns: cantidad de evades, foco 1 o 0 si aún lo posee o no.
    '''
    resultados = []
    for roll in range(dados):
        resultados.append(rollGreenDie())
    evades = resultados.count("evade")
    eyes = resultados.count("eye")
    #print(resultados)
    if foco == 1:
        if evades < hits:
            if eyes > 0:
                return evades + eyes, 0
            else:
                return evades, 1
        else: 
            return evades, 1
    return evades, 0
    
def rollRedDie():
    '''
        Lanza un dado rojo, retorna "hit, "eye" o "blank"
    '''
    num = numpy.random.randint(0,8)
    if num < 4:
        return "hit"
    if num < 6:
        return "eye"
    else:
        return "blank"


def rollGreenDie():
    '''
        Lanza un dado verde, retorna "evade, "eye" o "blank"
    '''
    num = numpy.random.randint(0,8)
    if num < 3:
        return "evade"
    if num < 5:
        return "eye"
    else:
        return "blank"