# -*- coding: utf-8 -*-
"""
Created on Wed Aug 21 11:51:25 2019
Estructura base para crear una simulacion de monte carlo
@author: Juampi
"""


import numpy

INTERVALO_REVISION_MC = 1000        # Miramos cada 1000 iteracione si tenemos suficiente,
NIVEL_DE_CONFIANZA = 1.96           # 95%
ERROR_ESPERADO = 0.01               # 1%

def simulacion():
    resultados_simulacion = [] #variable que estamos estimando, cada elemento del arreglo es una realización del experimento
    contador_iteraciones = 0
    suficientes_replicas = False #Flag de que aún no paramos
    
    while not(suficientes_replicas):
        contador_iteraciones = contador_iteraciones + 1
        '''
        Experimento de Monte Carlo: 
            La funcion Experimento() debe retornar el valor de la variable aleatoria que estamos estimando
        '''
        resultados_simulacion.append(Experimento())
     
        if contador_iteraciones%INTERVALO_REVISION_MC == 0 :            
            #Calculamos la varianza OJO ESTE PASO ES COMPUTACIONALMENTE CARO!!
            varianza_resultados = numpy.var(resultados_simulacion)
            #Revisamos la condicion de parada 
            #
            #   N >= 1.96^2*sigma^2/error^2
            #
            minN = numpy.power(NIVEL_DE_CONFIANZA/ERROR_ESPERADO,2)*varianza_resultados
            ########
            #Para solo ver una iteracion, descomentar las siguientes dos lineas:
            #print(resultados_simulacion)
            #break
            ###########
            print("A las %d iteraciones y varianza es %f necesitamos al menos N = %d iteraciones" % (contador_iteraciones, varianza_resultados, minN))
            if contador_iteraciones >= minN:
                suficientes_replicas = True
                
    '''
    Terminada la simulacion calculamos el promedio de los resultados y reportamos
    '''
    promedio_resultados= numpy.average(resultados_simulacion)
    print("El valor de la v.a. es %f" % promedio_resultados )
    
def Experimento():
    variable = 0
    '''
    Defina el experimento de monte carlo en esta funcion. Debe retornar la variable aleatoria
    '''
    return variable

if __name__ ==  '__main__':
    simulacion()
    