'''

'''

# -*- coding: utf-8 -*-
"""
Created on Wed Aug 21 11:51:25 2019
Ejemplo Clase 2:
    Determinar la probabilidad de que 3 atacantes destruyan un defensor en un turno
@author: Juampi
"""


import numpy

INTERVALO_REVISION_MC = 1000       # Miramos cada 1000 iteracione si tenemos suficiente,
NIVEL_DE_CONFIANZA = 1.96           # 95%
ERROR_ESPERADO = 0.01               # 1%


    

def simulacion():
    resultados_simulacion = [] #variable que estamos estimando, cada elemento del arreglo es una realización del experimento
    contador_iteraciones = 0
    suficientes_replicas = False #Flag de que aún no paramos
    
    while not(suficientes_replicas):
        contador_iteraciones = contador_iteraciones + 1
        '''
        Experimento de Monte Carlo: 
            La funcion Experimento() debe retornar el valor de la variable aleatoria que estamos estimando
        '''
        resultados_simulacion.append(Experimento())
     
        if contador_iteraciones%INTERVALO_REVISION_MC == 0 :            
            #Calculamos la varianza OJO ESTE PASO ES COMPUTACIONALMENTE CARO!!
            varianza_resultados = numpy.var(resultados_simulacion)
            #Revisamos la condicion de parada 
            #
            #   N >= 1.96^2*sigma^2/error^2
            #
            minN = numpy.power(NIVEL_DE_CONFIANZA/ERROR_ESPERADO,2)*varianza_resultados
            ########
            #Para solo ver una iteracion, descomentar las siguientes dos lineas:
            #print(resultados_simulacion)
            #break
            ###########
            print("A las %d iteraciones y varianza es %f necesitamos al menos N = %d iteraciones" % (contador_iteraciones, varianza_resultados, minN))
            if contador_iteraciones >= minN:
                suficientes_replicas = True
                
    '''
    Terminada la simulacion calculamos el promedio de los resultados y reportamos
    '''
    promedio_resultados= numpy.average(resultados_simulacion)
    print("El valor de la v.a. es %f" % promedio_resultados )


def Experimento():
    '''
    Esquema del experimento (Ojo que solo simulamos una ronda en este caso):
            Por cada atacente:
                Atacar 
                Defender
                Calcular HP restante
            Si HP = 0 -> unidad destruida -> iteracion es exito
            else  - iteracion falla
     retorno exito (1) o fracaso (0)
    '''
    import xwing as xw
    
    vida_objetivo = 6 #HARDCODED VIDA DEL DEFENSOR!!!!!!!!
    ataque = [[3,1],[3,1],[3,1]] #Primer elemento de cada par es el ataque y el segundo es la cantidad de focos
    defensa = [2,1]
  
    
    exito = 0
    dano_total = 0
    #Inicio de la ronda, ganan foco

    cont = 0
    for dados,foco_ataque in ataque:
        cont = cont+1
        num_hits, foco_ataque = xw.rollAttack(dados, foco_ataque)
        num_evade,defensa[1]= xw.rollDefense(defensa[0],defensa[1], num_hits)
        dano_total = dano_total + max(0, num_hits - num_evade)
        #print("Ataque %i: atacante %i defensor %i, vida %i" % (cont, num_hits, num_evade, vida_objetivo) )
    if dano_total >= 6:
        exito = 1
    return exito




if __name__ ==  '__main__':
    simulacion()
    







