# -*- coding: utf-8 -*-
'''   
    Clase Auxiliar 1
    Simulación de Monte Carlo para calcular la esperanza de un dado de cualquier cantidad de caras
'''

import numpy

ERROR_ESPERADO = 0.01
NIVEL_DE_CONFIANZA = 1.96 #95%
N_ITERACIONES_A_REVISAR = 1000

NUMERO_DE_CARAS = 6

class Dado:
    def __init__(self,param_caras):
        self.caras = param_caras

    def rollDie(self):
        resultado = numpy.random.randint(1,self.caras+1)
        return resultado

## Main

def main():
    paramos = False
    resultados = []
    iternum = 0
    while not(paramos):
        # Hasta que paremos tiramos el dado y lo guardamos
        d = Dado(NUMERO_DE_CARAS)
        resultados.append(d.rollDie())
        iternum = iternum + 1
        if iternum%N_ITERACIONES_A_REVISAR == 0 :
            #Calculamos la varianza
            variance = numpy.var(resultados,)
            #Revisamos la condicion de parada 
            #
            #   N >= 1.96^2*sigma^2/error^2
            #
            minN = numpy.power(NIVEL_DE_CONFIANZA/ERROR_ESPERADO,2)*variance
            print("llevamos "+str(iternum)+" iteraciones y la varianza es "+str(variance)+" Se estiman al N = "+str(minN)+" iteraciones")
            if iternum >= minN:
                paramos = True
    average = numpy.average(resultados)
    print("La esperanza es "+str(average))
if __name__ ==  '__main__':
    main()