# -*- coding: utf-8 -*-
"""
    Calculo de Pi usando el problema del Buffon's Needle
"""


import numpy

ERROR_ESPERADO = 0.001
NIVEL_DE_CONFIANZA = 1.96 #95%
N_ITERACIONES_A_REVISAR = 10000

def DropNeedle():
    distancia = numpy.random.random() #aleatorio entre 0 y 1
    angulo =  numpy.pi/2 * numpy.random.random() #aleatorio entra (b-a)*rand() + 1
    return distancia, angulo

## Main

def main():
    paramos = False
    resultados = []
    iternum = 0
    while not(paramos):
        # Hasta que paremos tiramos un aguja
        x,theta = DropNeedle()
        if x <= numpy.sin(theta)/2 :
            resultados.append(1)
        else: 
            resultados.append(0)
        iternum = iternum + 1
        if iternum%N_ITERACIONES_A_REVISAR == 0 :
            #Calculamos la varianza OJO ESTE PASO ES COMPUTACIONALMENTE CARO!!
            variance = numpy.var(resultados)
            #Revisamos la condicion de parada 
            #
            #   N >= 1.96^2*sigma^2/error^2
            #
            minN = numpy.power(NIVEL_DE_CONFIANZA/ERROR_ESPERADO,2)*variance
            print("llevamos "+str(iternum)+" iteraciones y la varianza es "+str(variance)+" Se estiman al N = "+str(minN)+" iteraciones")
            if iternum >= minN:
                paramos = True
    #Terminada la simulacion calculamos la esperanza y estimamos PI
    average = numpy.average(resultados)*2
    print("La esperanza es "+str(average))
    valor_de_pi = 2/average
    print("estimamos el valor de pi en :"+str(valor_de_pi))
    
    
if __name__ ==  '__main__':
    main()