# coding: utf-8

'''
Resumen de abstracción funcional:
Las tres funciones a usar reciben al menos una función y una lista.
- filtro retorna una lista de largo menor o igual
- mapa retorna una lista del mismo largo
- fold retorna un valor

Una vez entendido esto, reducimos a palabras la función de cada una de las
tres funciones:
- filtro, como dice su nombre, elimina los objetos de la lista donde la función
entregada retorne false
- mapa aplica la función entregada a cada uno de los elementos de la lista y
retorna el resultado
- fold aplica una función binaria a un valor "acumulado" con valor inicial init,
y opera el valor acumulado con los valores de la lista usando la función binaria entregada
'''


# Importar módulos
import estructura
from lista import *


# filtro: (X -> bool) lista(X) -> lista(X)
def filtro(operador, unaLista):
    if vacia(unaLista):
        return listaVacia
    else:
        if operador(cabeza(unaLista)):
            return lista(cabeza(unaLista), filtro(operador, cola(unaLista)))
        else:
            return filtro(operador, cola(unaLista))

        
# mapa: (X -> Y) lista(X) -> lista(Y)
def mapa(f, unaLista):
    if vacia(unaLista):
        return listaVacia
    else:
        return lista(f(cabeza(unaLista)), mapa(f, cola(unaLista)))


# fold: (X X -> Y) X lista(X) -> Z
def fold(f, init, unaLista):
    if cola(unaLista) == listaVacia:
        return f(init, cabeza(unaLista))
    else:
        return fold(f, f(init, cabeza(unaLista)), cola(unaLista))

###########################################################################
l = lista(200, lista(60, lista(0, lista(15, listaVacia))))


# a) Queremos aplicar una función a cada elemento de la lista, usamos map
# triplicar: lista -> lista
# triplica los valores de la lista
# ej: triplicar(l) = lista(600, lista(180, lista(0, lista(45, listaVacia))))
def triplicar(lista):
	return mapa(lambda x : 3*x, lista)

assert triplicar(l) == lista(600, lista(180, lista(0, lista(45, listaVacia))))

# b) Es el mismo caso que antes, usamos mapa
# aFarenheit: lista -> lista
# Convierte los valores de la lista a farenheit
# ej: aFarenheit(lista) = lista(232, lista(92, lista(32, lista(47, listaVacia))))
def aFarenheit(lista):
	return mapa(lambda x : 9/5 * x + 32, lista)
assert aFarenheit(l) == lista(232, lista(92, lista(32, lista(47, listaVacia))))

# c) Queremos filtrar por un criterio
# enRango: lista -> lista
# Retorna las temperaturas en farenheit entre los rangos a b y de lista
# ej: enRango(l, 30, 300) = lista(232, lista(92, lista(32, lista(47, listaVacia))))
def enRango(lista, a, b):
	enFar = aFarenheit(lista)
	return filtro(lambda x: a <= x and x <= b, enFar)
assert enRango(l, 90, 300) == lista(232, lista(92,listaVacia))

# d) Queremos un resultado de una lista, usamos fold
# aString: lista -> string
# Retorna los valores de la lista en un string, separados por un espacio
# ej: aString(l) = "200 60 0 15"
def aString(lista):
	ans = fold(lambda init, val: init + ' ' + str(val), '', lista)
	return ans[1:]
assert aString(l) == "200 60 0 15"