# -*- coding: UTF-8 -*-
from lista import *
import estructura

# Definimos la estructura y el nodoVacio
# nodo : valor(String) izq(nodo) der(nodo)
estructura.crear("nodo", "valor izq der")
arbolVacio = None

'''
Pregunta 3
'''

# magnetico : nodo(string) -> Bool
# Funcion que entrega verdadero o falso dependiendo si el arbol es magnetico o no
# Ej: nodo("N", arbolVacio, arbolVacio) entega True
# def validarArbol(A):
#   if A == None:
#     return ...
#   ... A.izq ...
#   ... A.der ...
#   return ...
def validarMagnetico(A):
    # suponemos que es un arbol binario
    if A == arbolVacio:
        return True
    else:
        hijoIzq = A.izq
        hijoDer = A.der
        # si ambos son nulos
        if hijoIzq == arbolVacio and hijoDer == arbolVacio:
            return True
        # si lo anterior no se cumple, alguno de los dos (no se sabe cual) es vacio
        # hijo izquierdo nulo
        if hijoIzq == arbolVacio:
            if hijoDer.valor == A.valor:
                return False
            else:
                return validarMagnetico(hijoDer)
        # hijo derecho nulo
        if hijoDer == arbolVacio:
            if hijoIzq.valor == A.valor:
                return False
            else:
                return validarMagnetico(hijoIzq)
        # llegados a este punto, entonces ambos son no nulos, podemos calcularles el valor
        if (hijoIzq.valor == hijoDer.valor) and hijoIzq.valor != A.valor:
            return validarMagnetico(hijoIzq) and validarMagnetico(hijoDer)
        else:
            return False

# Creamos un arbol de test antes de los assert y lo guardamos en una variable
# con eso hacemos más legible el llamado a la función validarMagnetico 
imanTree = nodo("S",
              nodo("N", arbolVacio, arbolVacio),
              nodo("N",
                 nodo("S", arbolVacio, arbolVacio),
                 nodo("S", arbolVacio, arbolVacio)
                 )
              )            

assert validarMagnetico(imanTree)
assert validarMagnetico(nodo("N", arbolVacio, arbolVacio))
assert not validarMagnetico(nodo("N",
                               arbolVacio,
                               nodo("N", arbolVacio, arbolVacio)
                               )
                            )

