# coding: utf-8
import estructura
# Nodo: valor(bool) izq(nodo) der(nodo)
estructura.crear("nodo", "valor izq der")

p = True
q = False
r = False
arbolEjemplo = nodo("and",
                    izq=nodo(p, None, None),
                    der=nodo("not",
                         izq=None,
                         der=nodo("or",
                              izq=nodo(q, None, None),
                              der=nodo(r, None, None))))

arbol2 = nodo("and",
              izq=nodo(p, None, None),
              der=nodo(q, None, None))

arbol3 = nodo("not",
              izq=None,
              der=arbol2)

arbol4 = nodo("and",
                izq=nodo(p, None, None),
                der=nodo("or",
                    izq=nodo(q, None, None),
                    der=nodo(r, None, None)))


# evaluar: nodo -> bool
# Evalua un arbol lógico y retorna el resultado
# ej: evaluar(arbolEjemplo) == True
# def evaluar(A):
#   if ... A.izq ... A.der ...:
#     return ...
#   ... A.izq ...
#   ... A.der ...
#   return ...
def evaluar(A):
  if A.izq == None and A.der == None: # Es un nodo
    return A.valor

  elif A.valor == 'and':
    return evaluar(A.izq) and evaluar(A.der)
  elif A.valor == 'or':
    return evaluar(A.izq) or evaluar(A.der)
  elif A.valor == 'not':
    return not evaluar(A.der)

assert evaluar(arbolEjemplo)

# negar: arbol(bool, arbol, arbol) -> arbol(bool, arbol, arbol)
# Entrega la negación de un arbol lógico
# ej: negar(arbolEjemplo) == nodo("or",
#                                izq=nodo("not", None, nodo(p, None, None)),
#                                der=nodo("or",
#                                    izq=nodo(q, None, None),
#                                    der=nodo(r, None, None)))
# def negar(A):
#   if A == None:
#     return ...
#   ... A.izq ...
#   ... A.der ...
#   return ...
def negar(arbol):
    if arbol.izq is None and arbol.der is None:
        valor = arbol.valor
        return nodo('not', None, nodo(valor, None, None))

    elif arbol.valor == 'and':
        # Niego recursivamente
        izq_neg = negar(arbol.izq)
        der_neg = negar(arbol.der)
        val = 'or'
        return nodo(val, izq_neg, der_neg)

    elif arbol.valor == 'or':
        # Niego recursivamente
        izq_neg = negar(arbol.izq)
        der_neg = negar(arbol.der)
        val = 'and'
        return nodo(val, izq_neg, der_neg)

    else: #Cuando es not
      arbol_der = arbol.der
      # No es necesario negar el resto
      return nodo(arbol_der.valor, arbol_der.izq, arbol_der.der)

assert negar(arbolEjemplo) == nodo("or",
                                izq=nodo("not", None, nodo(p, None, None)),
                                der=nodo("or",
                                    izq=nodo(q, None, None),
                                    der=nodo(r, None, None)))

assert negar(arbol4) == nodo("or",
                            izq=nodo("not", None, nodo(p, None, None)),
                            der=nodo("and",
                                izq=nodo("not", None, nodo(q, None, None)),
                                der=nodo("not", None, nodo(r, None,None)) ))



#########################################