% Condiciones iniciales
g = 9.8
gamma = 0.5
dt = 0.01
L = 0.5
t_fin = 10 % tiempo final

% Definimos el vector theta
th = zeros(1,t_fin/dt + 1); 

th(1) = pi/3; % Inicializamos los primeros valores
th(2) = pi/3;

T = 0

for i = 3:t_fin/dt % Iteramos hasta tiempo final
  % en cada iteracion calculamos el siguiente valor de theta
  th(i) = -g/L*sin(th(i-1))*dt*dt - gamma*(th(i-1)-th(i-2))*dt + 2*th(i-1)-th(i-2);
  
  % buscamos cuando la pendiente se hace 0, es decir cuando theta es maximo
  % asi podemos calcular el periodo del pendulo a medida que avanza el tiempo
  if (th(i-1)-th(i-2))*(th(i)-th(i-1)) <= 0
    disp(2*((i-1)*dt-T))
    T = (i-1)*dt;
    
  end 
end

% Graficamos el angulo en funcion del tiempo
plot(0:dt:t_fin,th)

