import java.util.HashMap;

public class HuffmanCode {

  public static void main(String[] args) {
    char[] caracteres = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
    double[] prioridades = new double[]{.5, .3, .15, .1, .04, .01};

    Arbol arbolHuffman = obtenerArbol(caracteres, prioridades);
    HashMap<Character, String> codigos = arbolHuffman.obtenerCodigos();

    System.out.println(arbolHuffman);

    for (Character key : codigos.keySet()) {
      System.out.println(key + ": " + codigos.get(key));
    }
  }

  static Arbol obtenerArbol(char[] caracteres, double[] prioridades) {
    MaxHeap2 cola = new MaxHeap2();

    // insertar todos los árboles de 1 nodo con cada caracter.
    for (int i = 0; i < caracteres.length; i++) {
      // como es un MaxHeap, se inserta la prioridad multiplicada por -1 para que el máximo sea el mínimo y viceversa.
      cola.insertar(new Arbol(caracteres[i], -1 * prioridades[i]));
    }

    // iterar hasta que quede solo 1 nodo.
    while (cola.tamagno >= 2) {

      // extraer los 2 mínimos.
      Arbol arbol1 = cola.extraerMax();
      Arbol arbol2 = cola.extraerMax();

      // se inserta un nuevo árbol conteniendo a los 2 anteriores con sus prioridades sumadas.
      cola.insertar(new Arbol(arbol1.prioridad + arbol2.prioridad, arbol1, arbol2));
    }

    // retornar el árbol final.
    return cola.extraerMax();
  }
}


/**
 * Clase para almacenar el código de Huffman, notar que tiene una función para obtener los códigos.
 */
class Arbol {
  char caracter;
  double prioridad;
  Arbol izq, der;

  public Arbol(char n, double p) {
    caracter = n;
    prioridad = p;
  }

  public Arbol(double p, Arbol i, Arbol d) {
    caracter = ' ';
    prioridad = p;
    izq = i;
    der = d;
  }

  // wrapper para hacer la llamada recursiva con valores iniciales
  HashMap<Character, String> obtenerCodigos() {
    return obtenerCodigos("");
  }

  HashMap<Character, String> obtenerCodigos(String prefijo) {
    // caso base, nodo hoja, se retorna el caracter asociado al código
    if (this.izq == null) {
      HashMap<Character, String> res =  new HashMap<Character, String>();
      res.put(this.caracter, prefijo);
      return res;
    }

    // llamadas recursivas agregando el código necesario al prefijo.
    HashMap<Character, String> codigos = new HashMap<Character, String>();
    codigos.putAll(this.izq.obtenerCodigos(prefijo + "0"));
    codigos.putAll(this.der.obtenerCodigos(prefijo + "1"));

    return codigos;
  }

  @Override
  public String toString() {
    return toString("");
  }

  public String toString(String pre) {
    if (this.izq == null) {
      return pre + this.caracter + ": " + this.prioridad + "\n";
    }

    // hijos izquierdos tienen . y derechos tienen -
    String stringIzq = izq.toString(pre + "| ");
    String stringder = der.toString(pre + "| ");

    return pre + "nodo interno\n" + stringIzq + stringder;
  }
}

/**
 * sí, tuve que copiar y pegar la clase para hacerle ajustes chicos, no tengo otra forma de hacerlo
 * (para los conocimientos de este curso)
  */
class MaxHeap2 {
  Arbol[] heap = new Arbol[100];
  int tamagno = 0;  // tamaño del heap

  /**
   * Funciones que definen las relaciones en el árbol, hijo izq, hijo derecho y padre.
   *
   * @param i el índice del nodo para el cuál se desea obtener la relación.
   * @return el índice del nodo deseado.
   */
  static int izq(int i) {
    return 2 * i + 1;
  }

  static int der(int i) {
    return 2 * i + 2;
  }

  static int padre(int i) {
    return (i - 1) / 2;
  }

  /**
   * Inserta un arbol en el heap y corrige los errores que puedan generarse.
   *
   * @param arbol el arbol a insertar
   */
  void insertar(Arbol arbol) {
    this.heap[tamagno] = arbol;
    bubbleUp(tamagno);
    tamagno++;
  }

  /**
   * Se insertó un valor en la posición nodo, hay que hacerlo "subir" hasta que el heap vuelva a estar ordenado
   *
   * @param nodo el índice donde se insertó un valor
   */
  private void bubbleUp(int nodo) {
    int i = nodo;
    while (i != 0) {
      if (heap[i].prioridad < heap[padre(i)].prioridad) {
        return;
      }
      swap(i, padre(i));
      i = padre(i);
    }
  }

  /**
   * intercambia 2 valores en el heap dados sus índices.
   */
  private void swap(int i, int j) {
    Arbol aux = heap[i];
    heap[i] = heap[j];
    heap[j] = aux;
  }

  /**
   * Extrae el máximo y corrige el heap.
   * @return
   */
  public Arbol extraerMax() {
    Arbol max = heap[0];
    heap[0] = heap[tamagno - 1];
    heap[tamagno - 1] = null;
    tamagno--;
    bubbleDown(0);
    return max;
  }


  /**
   * Se insertó un valor en la posición nodo, hay que hacerlo "bajar" hasta que el heap vuelva a estar ordenado
   *
   * @param nodo el índice donde se insertó un valor
   */
  private void bubbleDown(int nodo) {
    // nodo hoja, no tiene hijos, termina.
    if (izq(nodo) >= tamagno) {
      return;
    }

    // tiene hijo izquierdo sí o sí.
    int max = izq(nodo);

    // si tiene hijo derecho, hay que ver si es más grande que el izquierdo.
    if (der(nodo) < tamagno) {
      if (heap[max].prioridad < heap[der(nodo)].prioridad) {
        max = der(nodo);
      }
    }

    // heap ordenado, termina.
    if (heap[nodo].prioridad > heap[max].prioridad) {
      return;
    }

    // reemplazar por el máximo y seguir recursivamente.
    swap(nodo, max);
    bubbleDown(max);
  }
}