public class MaxHeap {
  BeyLuchador[] heap = new BeyLuchador[100];
  int tamagno = 0;  // tamaño del heap

  /**
   * Funciones que definen las relaciones en el árbol, hijo izq, hijo derecho y padre.
   *
   * @param i el índice del nodo para el cuál se desea obtener la relación.
   * @return el índice del nodo deseado.
   */
  static int izq(int i) {
    return 2 * i + 1;
  }

  static int der(int i) {
    return 2 * i + 2;
  }

  static int padre(int i) {
    return (i - 1) / 2;
  }

  /**
   * Inserta un BeyLuchador en el heap y corrige los errores que puedan generarse.
   *
   * @param luchador el BeyLuchador a insertar
   */
  void insertar(BeyLuchador luchador) {
    this.heap[tamagno] = luchador;
    bubbleUp(tamagno);
    tamagno++;
  }

  /**
   * Se insertó un valor en la posición nodo, hay que hacerlo "subir" hasta que el heap vuelva a estar ordenado
   *
   * @param nodo el índice donde se insertó un valor
   */
  private void bubbleUp(int nodo) {
    int i = nodo;
    while (i != 0) {
      if (heap[i].poder < heap[padre(i)].poder) {
        return;
      }
      swap(i, padre(i));
      i = padre(i);
    }
  }

  /**
   * intercambia 2 valores en el heap dados sus índices.
   */
  private void swap(int i, int j) {
    BeyLuchador aux = heap[i];
    heap[i] = heap[j];
    heap[j] = aux;
  }

  /**
   * Extrae el máximo y corrige el heap.
   * @return
   */
  public BeyLuchador extraerMax() {
    BeyLuchador max = heap[0];
    heap[0] = heap[tamagno - 1];
    heap[tamagno - 1] = null;
    tamagno--;
    bubbleDown(0);
    return max;
  }


  /**
   * Se insertó un valor en la posición nodo, hay que hacerlo "bajar" hasta que el heap vuelva a estar ordenado
   *
   * @param nodo el índice donde se insertó un valor
   */
  private void bubbleDown(int nodo) {
    // nodo hoja, no tiene hijos, termina.
    if (izq(nodo) >= tamagno) {
      return;
    }

    // tiene hijo izquierdo sí o sí.
    int max = izq(nodo);

    // si tiene hijo derecho, hay que ver si es más grande que el izquierdo.
    if (der(nodo) < tamagno) {
      if (heap[max].poder < heap[der(nodo)].poder) {
        max = der(nodo);
      }
    }

    // heap ordenado, termina.
    if (heap[nodo].poder > heap[max].poder) {
      return;
    }

    // reemplazar por el máximo y seguir recursivamente.
    swap(nodo, max);
    bubbleDown(max);
  }

  @Override
  /**
   * Método que permite utilizar println() para imprimir el heap.
   */
  public String toString() {
    String res = "Heap:\n";
    for (int i = 0; i < tamagno; i++) {
      res += heap[i].nombre + ", " + heap[i].poder + "\n";
    }
    return res;
  }

  public static void main(String[] args) {
    MaxHeap heap = new MaxHeap();

    heap.insertar(new BeyLuchador("max", 1000));
    System.out.println(heap);
    heap.insertar(new BeyLuchador("cristóbal", 2));
    System.out.println(heap);
    heap.insertar(new BeyLuchador("bernardo", 9001));
    System.out.println(heap);
    heap.insertar(new BeyLuchador("jérémy", 1000000));
    System.out.println(heap);

    BeyLuchador max = heap.extraerMax();
    System.out.println("máximo: " + max.nombre + ", " + max.poder);
    System.out.println(heap);

  }
}

class BeyLuchador {
  String nombre;
  double poder;

  public BeyLuchador(String n, double p) {
    nombre = n;
    poder = p;
  }
}