
public class NodoArbolBinario
{
	private int dato;//
	private NodoArbolBinario nodo_Izq;
	private NodoArbolBinario nodo_Der;
	
	public NodoArbolBinario(int dato, NodoArbolBinario t_izq, NodoArbolBinario t_der)
	{
		this.dato=dato;
		this.nodo_Der=t_der;
		this.nodo_Izq=t_izq;
	}
	
	
	
	public NodoArbolBinario(int dato)
	{
		this(dato,null,null);
	}
		
	public int getSize()
	{
		int sI=0, sD=0;
		sI=(nodo_Izq==null)?0:nodo_Izq.getSize();
		sD=(nodo_Der==null)?0:nodo_Der.getSize();
		return sI+sD+1;
	}
		
	//Para recorridos
	public void recorrerInOrden()
	{
		if(nodo_Izq!=null) nodo_Izq.recorrerInOrden();
		System.out.print(" "+ dato);
		if(nodo_Der!=null) nodo_Der.recorrerInOrden();
	}
	
	/*-----------------------------------------------------------------*/
	public static boolean esValidoDer(int dato, NodoArbolBinario der)
	{
		boolean r=false;
		int x_menor=-1;
		NodoArbolBinario p=null;
		if(der==null)
		{
			r=true;
		}
		else
		{
			p=der; //buscamos el mayor de la derecha
			while(p!=null)
			{
				x_menor=p.dato; //almacena el mayor, al menor habrá uno
				p=p.nodo_Izq;
			}
			if(dato<x_menor) r=true;			
		}
		return  r;
	}
	
	/*-----------------------------------------------------------------*/
	public static boolean esValidoIzq(int dato, NodoArbolBinario izq)
	{
		boolean r=false;
		int x_mayor=-1;
		NodoArbolBinario p=null;
		if(izq==null)
		{
			r=true;
		}
		else
		{
			p=izq; //buscamos el mayor de la derecha
			while(p!=null)
			{
				x_mayor=p.dato; //almacena el mayor, al menor habrá uno
				p=p.nodo_Der;
			}
			if(dato>x_mayor) r=true;			
		}
		return  r;
	}
	/*-----------------------------------------------------------------*/
	public boolean esABB()
	{
		boolean r=false;
		if (nodo_Der==null || nodo_Der.esABB())
		{
			if (nodo_Izq==null || nodo_Izq.esABB())
			{
				if (esValidoDer(dato, nodo_Der)&& esValidoIzq(dato,nodo_Izq))
				{
					r=true;
				}
			}
		}
		return r;
	}	
	/*-----------------------------------------------------------------*/
	public static boolean esValidoDerN(int dato, NodoResultado rder)
	{
		boolean r=false;
		if (rder==null) r=true;
		else
		{
			if(dato<rder.menor)
			{
				r=true;
			}
		}
		return r;
	}
	
	public static boolean esValidoIzqN(int dato, NodoResultado rizq)
	{
		boolean r=false;
		if (rizq==null) r=true;
		else
		{
			if(dato>rizq.mayor)
			{
				r=true;
			}
		}
		return r;
	}
	/*-----------------------------------------------------------------*/
	public NodoResultado esABBOrdenN()
	{
		NodoResultado r=null, rizq=null, rder=null;
		boolean abbIzq=false, abbDer=false;		
		r=new NodoResultado();
		r.esABB=false;
		
		if(nodo_Der==null) abbDer=true;
		else 
		{
			rder=nodo_Der.esABBOrdenN();
			abbDer=rder.esABB;
		}
		
		if(nodo_Izq==null) abbIzq=true;
		else
		{
			rizq=nodo_Izq.esABBOrdenN();
			abbIzq=rizq.esABB;
		}
		
		if(abbDer && abbIzq)
		{
			if (esValidoDerN(dato, rder)&& esValidoIzqN(dato,rizq))
			{
				if(rder==null) r.mayor=dato;
				else r.mayor=rder.mayor;
				
				if(rizq==null) r.menor=dato;
				else r.menor=rizq.menor;
				r.esABB=true;
			}
		}
		
		
	
	
	
	
	
		return r;
	}	
	/*-----------------------------------------------------------------*/
	public int getDato(){return dato;}
	public NodoArbolBinario getNodoIzq(){return nodo_Izq;}
	public NodoArbolBinario getNodoDer(){return nodo_Der;}
}
