package aux6;

public class Pila {
	int[] pila;
	int punta;

	public Pila() {
		pila = new int[10]; // largo inicial no depende de nada
		punta = 0;
	}

	public void apilar(int e) {
		if (this.estaLlena())
			this.agrandarPila();

		pila[punta] = e;
		punta++;
	}

	public int desapilar() {
		// el ultimo elemento esta en pila[punta - 1] y ademas debemos disminuir en 1 el
		// tamao
		punta--;
		return pila[punta];
	}

	public boolean estaVacia() {
		return punta == 0;
	}

	/*
	 * noten que los siguientes metodos son privados porque el usuario no deberia
	 * poder usarlos, solo se usan de manera interna. Para el usuario la pila nunca
	 * esta llena y el no puede decidir agrandar la pila.
	 */

	private boolean estaLlena() {
		return punta == pila.length;
	}

	private void agrandarPila() {
		// creamos nueva pila con el doble de espacio
		int[] nueva = new int[pila.length * 2];

		// copiamos los elementos
		for (int i = 0; i < pila.length; i++) {
			nueva[i] = pila[i];
		}

		// reasignamos al nuevo arreglo
		pila = nueva;
	}

	// Calculadora. El manejo de errores se hace retornando -1, aunque no es una
	// buena forma de hacerlo ya que -1 es un resultado posible. Mas adelante en el
	// curso veremos una buena forma de manejar errores-
	public static int evaluar(String s) {

		String[] ecuacion = s.split(" ");
		Pila pila = new Pila();

		for (int i = 0; i < ecuacion.length; i++) {

			// operacion
			if ("+-*/".contains(ecuacion[i])) {

				// desapilar elementos para la operacion, comprobando que no haya error.
				if (pila.estaVacia())
					return -1;
				int b = pila.desapilar();

				// el segundo elemento es el primero que entro en la pila, por lo tanto es el
				// primer operando
				if (pila.estaVacia())
					return -1;
				int a = pila.desapilar();

				if (ecuacion[i].equals("+")) {
					pila.apilar(a + b);
				} else if (ecuacion[i].equals("-")) {
					pila.apilar(a - b);
				} else if (ecuacion[i].equals("*")) {
					pila.apilar(a * b);
				} else {
					pila.apilar(a / b);
				}

			} else {
				// asumimos que es un numero
				pila.apilar(Integer.parseInt(ecuacion[i]));
			}
		}

		int ret = pila.desapilar();

		// si la pila no esta vacia al final, lanzar error.
		if (!pila.estaVacia())
			return -1;

		return ret;
	}

	public static void main(String[] args) {
		System.out.println("Todos los casos a continuacion deberian retornar true");

		System.out.println(evaluar("1 2 +") == 3);

		System.out.println(evaluar("3 4 7 + 5 - *") == 18);

		System.out.println(evaluar("1") == 1);

		System.out.println(evaluar("6 8") == -1);

		System.out.println(evaluar("6 4 * +") == -1);

		System.out.println(evaluar("1 2 + 3 - * 5 6 7") == -1);
	}
}
