package aux6;

import aux6.ListaEnlazada;

public class Cola {
	ListaEnlazada cabeza;
	ListaEnlazada cola;

	public Cola() {
		cabeza = cola = null;
	}

	public boolean estaVacia() {
		return cabeza == null;
	}

	public void encolar(AB e) {
		if (estaVacia()) {
			cabeza = cola = new ListaEnlazada(e);
		} else {
			cola.sig = new ListaEnlazada(e);
			cola = cola.sig;
		}
	}

	public AB desencolar() {
		AB e = cabeza.valor;
		cabeza = cabeza.sig;
		return e;
	}

	public static void DFS(AB arbol) {
		Cola cola = new Cola();
		cola.encolar(arbol);
		
		String nodos = "";

		while (!cola.estaVacia()) {
			AB nodo = cola.desencolar();

			// si el nodo es nulo se ignora
			if (nodo == null) {
				continue;
			}

			nodos += nodo.val + " ";

			// si se encuentra al gatito terminar
			if (nodo.gatito)
				break;

			cola.encolar(nodo.izq);
			cola.encolar(nodo.der);
		}

		System.out.println(nodos.trim());
	}

	public static void main(String[] args) {
		AB arbol = new AB(42, 
				new AB(21, 
						new AB(15, 
								new AB(4), 
								null), 
						new AB(27)), 
				new AB(78, 
						new AB(49,
								null,
								new AB(57)),
						null));
		
		arbol.izq.izq.izq.gatito = true; // ubicar gato en el nodo 4

		DFS(arbol);
	}
}
