
public class ListaEnlazada {
	
	public static void main(String[] sfhjgfjhq) {
		ListaEnlazada l1 = new ListaEnlazada(8);
		ListaEnlazada l2 = new ListaEnlazada(6, l1);
		ListaEnlazada l3 = new ListaEnlazada(10, l2);
		ListaEnlazada l4 = new ListaEnlazada(3, l3);
		ListaEnlazada l5 = new ListaEnlazada(5, l4);
		l1.sig = l5;
		
		System.out.println(Josephus(l5, 3));
	}

	// cada nodo almacena un valor y un enlace al siguiente nodo.
	int valor;
	ListaEnlazada sig;
	
	/**
	 * se crean 2 constructores, uno recibe solo el valor y el enlace se deja nulo,
	 * el otro recibe el valor y el enlace al siguiente nodo. 
	 */
	public ListaEnlazada(int valor) {
		this.valor = valor;
		sig = null;
	}
	
	public ListaEnlazada(int valor, ListaEnlazada sig) {
		this.valor = valor;
		this.sig = sig;
	}
	
	/**
	 * retorna el largo de la lista
	 */
	public int largo() {
		ListaEnlazada primero = this;
		
		// se parte contando el primer elemento y avanzando al siguiente.
		int largo = 1;
		ListaEnlazada actual = this.sig;

		// recorrer la lista hasta que se acabe (actual = null) o se complete un ciclo.
		while (actual != null && actual != primero) {
			largo++;
			actual = actual.sig;
		}
		
		return largo;
	}
	
	/**
	 * retorna el i-esimo elemento de una lsita, es vlido ciclar sobre la lista.
	 * si no existe retorna -1
	 */
	public int obtener(int i) {
		ListaEnlazada actual = this;

		// recorrer la lista hasta que i sea 0 o el nodo sea null.
		while (actual != null && i != 0) {
			i--;
			
			actual = actual.sig;
		}
		
		// no existe el i-esimo elemento.
		if (actual == null)
			return -1;
		
		return actual.valor;
	}
	
	/**
	 * elimina el k-esimo elemento (es vlido ciclar sobre la lista) y retorna el elemento siguiente al eliminado.
	 */
	public ListaEnlazada eliminar(int i) {
		ListaEnlazada actual = this;
		ListaEnlazada anterior = null;
		
		// recorrer la lista hasta que i sea 0.
		while (actual != null && i != 0) {
			i--;
			
			anterior = actual;
			actual = actual.sig;
		}
		
		// caso borde en el que se elimina el primer elemento.
		if (anterior == null)
			return actual.sig;
		
		// esta asignacin "borra" el elemento actual.
		anterior.sig = actual.sig;
		
		return actual.sig;
	}
	
	public static int Josephus(ListaEnlazada L, int k) {
		// caso base, cuando queda un elemento se retorna su valor.
		if (L.largo() == 1)
			return L.valor;
		
		// recursivamente eliminar el k-esimo elemento.
		return Josephus(L.eliminar(k), k);
	}
}